# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from .street_address_base import StreetAddressBase


class StreetAddressLongZip(StreetAddressBase):
    """
    Examples
    --------
    from candid.resources.commons import State, StreetAddressLongZip

    StreetAddressLongZip(
        address_1="123 Main St",
        address_2="Apt 1",
        city="New York",
        state=State.NY,
        zip_code="10001",
        zip_plus_four_code="1234",
    )
    """

    zip_plus_four_code: str = pydantic.Field()
    """
    4-digit zip add-on code https://en.wikipedia.org/wiki/ZIP_Code#ZIP+4
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
