# This file was auto-generated by Fern from our API Definition.

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawContractsClient, RawContractsClient
from .resources.v_2.client import AsyncV2Client, V2Client


class ContractsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawContractsClient(client_wrapper=client_wrapper)
        self.v_2 = V2Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawContractsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawContractsClient
        """
        return self._raw_client


class AsyncContractsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawContractsClient(client_wrapper=client_wrapper)
        self.v_2 = AsyncV2Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawContractsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawContractsClient
        """
        return self._raw_client
