# This file was auto-generated by Fern from our API Definition.

import typing
import uuid

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ....commons.types.date import Date
from ....commons.types.page_token import PageToken
from ....commons.types.regions import Regions
from ....commons.types.sort_direction import SortDirection
from ....commons.types.state import State
from .raw_client import AsyncRawV2Client, RawV2Client
from .types.authorized_signatory import AuthorizedSignatory
from .types.authorized_signatory_update import AuthorizedSignatoryUpdate
from .types.contract_id import ContractId
from .types.contract_sort_field import ContractSortField
from .types.contract_status import ContractStatus
from .types.contract_with_providers import ContractWithProviders
from .types.contracting_provider_id import ContractingProviderId
from .types.contracts_page import ContractsPage
from .types.date_update import DateUpdate
from .types.insurance_types import InsuranceTypes
from .types.regions_update import RegionsUpdate
from .types.rendering_providerid import RenderingProviderid

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V2Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV2Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV2Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV2Client
        """
        return self._raw_client

    def get(
        self, contract_id: ContractId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ContractWithProviders:
        """
        Parameters
        ----------
        contract_id : ContractId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContractWithProviders

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.contracts.v_2.get(
            contract_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.get(contract_id, request_options=request_options)
        return _response.data

    def get_multi(
        self,
        *,
        page_token: typing.Optional[PageToken] = None,
        limit: typing.Optional[int] = None,
        contracting_provider_id: typing.Optional[ContractingProviderId] = None,
        rendering_provider_ids: typing.Optional[
            typing.Union[RenderingProviderid, typing.Sequence[RenderingProviderid]]
        ] = None,
        payer_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        states: typing.Optional[typing.Union[State, typing.Sequence[State]]] = None,
        contract_status: typing.Optional[ContractStatus] = None,
        sort: typing.Optional[ContractSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ContractsPage:
        """
        Parameters
        ----------
        page_token : typing.Optional[PageToken]

        limit : typing.Optional[int]
            Max number of contracts returned. Defaults to 1000. Max is 1000.

        contracting_provider_id : typing.Optional[ContractingProviderId]

        rendering_provider_ids : typing.Optional[typing.Union[RenderingProviderid, typing.Sequence[RenderingProviderid]]]

        payer_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter to contracts that include any of the included payer names.

        states : typing.Optional[typing.Union[State, typing.Sequence[State]]]

        contract_status : typing.Optional[ContractStatus]
            The status of the contract. Defaults to `pending`

        sort : typing.Optional[ContractSortField]
            Potentially sort by a contract related attribute.  Defaults to created_at

        sort_direction : typing.Optional[SortDirection]
            Direction of sort, defaulting to desc

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContractsPage

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.contracts.v_2.get_multi()
        """
        _response = self._raw_client.get_multi(
            page_token=page_token,
            limit=limit,
            contracting_provider_id=contracting_provider_id,
            rendering_provider_ids=rendering_provider_ids,
            payer_names=payer_names,
            states=states,
            contract_status=contract_status,
            sort=sort,
            sort_direction=sort_direction,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        contracting_provider_id: ContractingProviderId,
        rendering_provider_ids: typing.Set[RenderingProviderid],
        payer_uuid: uuid.UUID,
        effective_date: Date,
        regions: Regions,
        commercial_insurance_types: InsuranceTypes,
        medicare_insurance_types: InsuranceTypes,
        medicaid_insurance_types: InsuranceTypes,
        expiration_date: typing.Optional[Date] = OMIT,
        contract_status: typing.Optional[ContractStatus] = OMIT,
        authorized_signatory: typing.Optional[AuthorizedSignatory] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ContractWithProviders:
        """
        Creates a new contract within the user's current organization

        Parameters
        ----------
        contracting_provider_id : ContractingProviderId
            The UUID of the provider under agreement to the contract

        rendering_provider_ids : typing.Set[RenderingProviderid]
            A rendering provider isn't contracted directly with the payer but can render
            services under the contract held by the contracting provider.
            Max items is 1000.

        payer_uuid : uuid.UUID
            The UUID of the insurance company under agreement to the contract

        effective_date : Date
            The starting day upon which the contract is effective

        regions : Regions
            The state(s) to which the contract's coverage extends.
            It may also be set to "national" for the entirety of the US.

        commercial_insurance_types : InsuranceTypes
            The commercial plan insurance types this contract applies.

        medicare_insurance_types : InsuranceTypes
            The Medicare plan insurance types this contract applies.

        medicaid_insurance_types : InsuranceTypes
            The Medicaid plan insurance types this contract applies.

        expiration_date : typing.Optional[Date]
            An optional end day upon which the contract expires

        contract_status : typing.Optional[ContractStatus]

        authorized_signatory : typing.Optional[AuthorizedSignatory]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContractWithProviders

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.contracts.v_2.create(
            contracting_provider_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            rendering_provider_ids=[
                uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                )
            ],
            payer_uuid=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.create(
            contracting_provider_id=contracting_provider_id,
            rendering_provider_ids=rendering_provider_ids,
            payer_uuid=payer_uuid,
            effective_date=effective_date,
            regions=regions,
            commercial_insurance_types=commercial_insurance_types,
            medicare_insurance_types=medicare_insurance_types,
            medicaid_insurance_types=medicaid_insurance_types,
            expiration_date=expiration_date,
            contract_status=contract_status,
            authorized_signatory=authorized_signatory,
            request_options=request_options,
        )
        return _response.data

    def delete(self, contract_id: ContractId, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        contract_id : ContractId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.contracts.v_2.delete(
            contract_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.delete(contract_id, request_options=request_options)
        return _response.data

    def update(
        self,
        contract_id: ContractId,
        *,
        rendering_provider_ids: typing.Optional[typing.Set[RenderingProviderid]] = OMIT,
        effective_date: typing.Optional[Date] = OMIT,
        expiration_date: typing.Optional[DateUpdate] = OMIT,
        regions: typing.Optional[RegionsUpdate] = OMIT,
        contract_status: typing.Optional[ContractStatus] = OMIT,
        authorized_signatory: typing.Optional[AuthorizedSignatoryUpdate] = OMIT,
        commercial_insurance_types: typing.Optional[InsuranceTypes] = OMIT,
        medicare_insurance_types: typing.Optional[InsuranceTypes] = OMIT,
        medicaid_insurance_types: typing.Optional[InsuranceTypes] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ContractWithProviders:
        """
        Parameters
        ----------
        contract_id : ContractId

        rendering_provider_ids : typing.Optional[typing.Set[RenderingProviderid]]
            A rendering provider isn't contracted directly with the payer but can render
            services under the contract held by the contracting provider.
            Max items is 1000.

        effective_date : typing.Optional[Date]
            The starting day upon which the contract is effective

        expiration_date : typing.Optional[DateUpdate]
            An optional end day upon which the contract expires

        regions : typing.Optional[RegionsUpdate]
            If present, the contract's rendering providers will be patched to this exact
            value, overriding what was set before.

        contract_status : typing.Optional[ContractStatus]

        authorized_signatory : typing.Optional[AuthorizedSignatoryUpdate]

        commercial_insurance_types : typing.Optional[InsuranceTypes]

        medicare_insurance_types : typing.Optional[InsuranceTypes]

        medicaid_insurance_types : typing.Optional[InsuranceTypes]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContractWithProviders

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.contracts.v_2.update(
            contract_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.update(
            contract_id,
            rendering_provider_ids=rendering_provider_ids,
            effective_date=effective_date,
            expiration_date=expiration_date,
            regions=regions,
            contract_status=contract_status,
            authorized_signatory=authorized_signatory,
            commercial_insurance_types=commercial_insurance_types,
            medicare_insurance_types=medicare_insurance_types,
            medicaid_insurance_types=medicaid_insurance_types,
            request_options=request_options,
        )
        return _response.data


class AsyncV2Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV2Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV2Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV2Client
        """
        return self._raw_client

    async def get(
        self, contract_id: ContractId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ContractWithProviders:
        """
        Parameters
        ----------
        contract_id : ContractId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContractWithProviders

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.contracts.v_2.get(
                contract_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(contract_id, request_options=request_options)
        return _response.data

    async def get_multi(
        self,
        *,
        page_token: typing.Optional[PageToken] = None,
        limit: typing.Optional[int] = None,
        contracting_provider_id: typing.Optional[ContractingProviderId] = None,
        rendering_provider_ids: typing.Optional[
            typing.Union[RenderingProviderid, typing.Sequence[RenderingProviderid]]
        ] = None,
        payer_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        states: typing.Optional[typing.Union[State, typing.Sequence[State]]] = None,
        contract_status: typing.Optional[ContractStatus] = None,
        sort: typing.Optional[ContractSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ContractsPage:
        """
        Parameters
        ----------
        page_token : typing.Optional[PageToken]

        limit : typing.Optional[int]
            Max number of contracts returned. Defaults to 1000. Max is 1000.

        contracting_provider_id : typing.Optional[ContractingProviderId]

        rendering_provider_ids : typing.Optional[typing.Union[RenderingProviderid, typing.Sequence[RenderingProviderid]]]

        payer_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter to contracts that include any of the included payer names.

        states : typing.Optional[typing.Union[State, typing.Sequence[State]]]

        contract_status : typing.Optional[ContractStatus]
            The status of the contract. Defaults to `pending`

        sort : typing.Optional[ContractSortField]
            Potentially sort by a contract related attribute.  Defaults to created_at

        sort_direction : typing.Optional[SortDirection]
            Direction of sort, defaulting to desc

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContractsPage

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.contracts.v_2.get_multi()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_multi(
            page_token=page_token,
            limit=limit,
            contracting_provider_id=contracting_provider_id,
            rendering_provider_ids=rendering_provider_ids,
            payer_names=payer_names,
            states=states,
            contract_status=contract_status,
            sort=sort,
            sort_direction=sort_direction,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        contracting_provider_id: ContractingProviderId,
        rendering_provider_ids: typing.Set[RenderingProviderid],
        payer_uuid: uuid.UUID,
        effective_date: Date,
        regions: Regions,
        commercial_insurance_types: InsuranceTypes,
        medicare_insurance_types: InsuranceTypes,
        medicaid_insurance_types: InsuranceTypes,
        expiration_date: typing.Optional[Date] = OMIT,
        contract_status: typing.Optional[ContractStatus] = OMIT,
        authorized_signatory: typing.Optional[AuthorizedSignatory] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ContractWithProviders:
        """
        Creates a new contract within the user's current organization

        Parameters
        ----------
        contracting_provider_id : ContractingProviderId
            The UUID of the provider under agreement to the contract

        rendering_provider_ids : typing.Set[RenderingProviderid]
            A rendering provider isn't contracted directly with the payer but can render
            services under the contract held by the contracting provider.
            Max items is 1000.

        payer_uuid : uuid.UUID
            The UUID of the insurance company under agreement to the contract

        effective_date : Date
            The starting day upon which the contract is effective

        regions : Regions
            The state(s) to which the contract's coverage extends.
            It may also be set to "national" for the entirety of the US.

        commercial_insurance_types : InsuranceTypes
            The commercial plan insurance types this contract applies.

        medicare_insurance_types : InsuranceTypes
            The Medicare plan insurance types this contract applies.

        medicaid_insurance_types : InsuranceTypes
            The Medicaid plan insurance types this contract applies.

        expiration_date : typing.Optional[Date]
            An optional end day upon which the contract expires

        contract_status : typing.Optional[ContractStatus]

        authorized_signatory : typing.Optional[AuthorizedSignatory]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContractWithProviders

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.contracts.v_2.create(
                contracting_provider_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                rendering_provider_ids=[
                    uuid.UUID(
                        "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                    )
                ],
                payer_uuid=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            contracting_provider_id=contracting_provider_id,
            rendering_provider_ids=rendering_provider_ids,
            payer_uuid=payer_uuid,
            effective_date=effective_date,
            regions=regions,
            commercial_insurance_types=commercial_insurance_types,
            medicare_insurance_types=medicare_insurance_types,
            medicaid_insurance_types=medicaid_insurance_types,
            expiration_date=expiration_date,
            contract_status=contract_status,
            authorized_signatory=authorized_signatory,
            request_options=request_options,
        )
        return _response.data

    async def delete(self, contract_id: ContractId, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        contract_id : ContractId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.contracts.v_2.delete(
                contract_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(contract_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        contract_id: ContractId,
        *,
        rendering_provider_ids: typing.Optional[typing.Set[RenderingProviderid]] = OMIT,
        effective_date: typing.Optional[Date] = OMIT,
        expiration_date: typing.Optional[DateUpdate] = OMIT,
        regions: typing.Optional[RegionsUpdate] = OMIT,
        contract_status: typing.Optional[ContractStatus] = OMIT,
        authorized_signatory: typing.Optional[AuthorizedSignatoryUpdate] = OMIT,
        commercial_insurance_types: typing.Optional[InsuranceTypes] = OMIT,
        medicare_insurance_types: typing.Optional[InsuranceTypes] = OMIT,
        medicaid_insurance_types: typing.Optional[InsuranceTypes] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ContractWithProviders:
        """
        Parameters
        ----------
        contract_id : ContractId

        rendering_provider_ids : typing.Optional[typing.Set[RenderingProviderid]]
            A rendering provider isn't contracted directly with the payer but can render
            services under the contract held by the contracting provider.
            Max items is 1000.

        effective_date : typing.Optional[Date]
            The starting day upon which the contract is effective

        expiration_date : typing.Optional[DateUpdate]
            An optional end day upon which the contract expires

        regions : typing.Optional[RegionsUpdate]
            If present, the contract's rendering providers will be patched to this exact
            value, overriding what was set before.

        contract_status : typing.Optional[ContractStatus]

        authorized_signatory : typing.Optional[AuthorizedSignatoryUpdate]

        commercial_insurance_types : typing.Optional[InsuranceTypes]

        medicare_insurance_types : typing.Optional[InsuranceTypes]

        medicaid_insurance_types : typing.Optional[InsuranceTypes]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContractWithProviders

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.contracts.v_2.update(
                contract_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            contract_id,
            rendering_provider_ids=rendering_provider_ids,
            effective_date=effective_date,
            expiration_date=expiration_date,
            regions=regions,
            contract_status=contract_status,
            authorized_signatory=authorized_signatory,
            commercial_insurance_types=commercial_insurance_types,
            medicare_insurance_types=medicare_insurance_types,
            medicaid_insurance_types=medicaid_insurance_types,
            request_options=request_options,
        )
        return _response.data
