# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2
from .....organization_providers.resources.v_2.types.organization_provider import OrganizationProvider
from .....payers.resources.v_3.types.payer import Payer
from .contract_base import ContractBase
from .contract_id import ContractId


class Contract(ContractBase):
    contract_id: ContractId
    contracting_provider: OrganizationProvider = pydantic.Field()
    """
    The provider under contract
    """

    provider_count: int = pydantic.Field()
    """
    The number of linked providers who can render medical services under this contract
    """

    payer: Payer = pydantic.Field()
    """
    The insurance company under contract
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
