# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ContractStatus(str, enum.Enum):
    PENDING = "pending"
    """
    Contract is still in the works and has not been signed and counter-signed yet
    """

    EFFECTIVE = "effective"
    """
    Contract is active and in effect (claims will need to
    be submitted under effective contracts)
    """

    CANCELLED = "cancelled"
    """
    Contract is no longer effective but kept around for historical documentation
    """

    _UNKNOWN = "__CONTRACTSTATUS_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "ContractStatus":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        pending: typing.Callable[[], T_Result],
        effective: typing.Callable[[], T_Result],
        cancelled: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is ContractStatus.PENDING:
            return pending()
        if self is ContractStatus.EFFECTIVE:
            return effective()
        if self is ContractStatus.CANCELLED:
            return cancelled()
        return _unknown_member(self._value_)
