# This file was auto-generated by Fern from our API Definition.

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawCredentialingClient, RawCredentialingClient
from .resources.v_2.client import AsyncV2Client, V2Client


class CredentialingClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCredentialingClient(client_wrapper=client_wrapper)
        self.v_2 = V2Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCredentialingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCredentialingClient
        """
        return self._raw_client


class AsyncCredentialingClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCredentialingClient(client_wrapper=client_wrapper)
        self.v_2 = AsyncV2Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCredentialingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCredentialingClient
        """
        return self._raw_client
