# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
import uuid
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.jsonable_encoder import jsonable_encoder
from .....core.pydantic_utilities import parse_obj_as
from .....core.request_options import RequestOptions
from ....commons.errors.entity_not_found_error import EntityNotFoundError
from ....commons.errors.http_request_validations_error import HttpRequestValidationsError
from ....commons.errors.unauthorized_error import UnauthorizedError
from ....commons.errors.unprocessable_entity_error import UnprocessableEntityError
from ....commons.types.entity_not_found_error_message import EntityNotFoundErrorMessage
from ....commons.types.page_token import PageToken
from ....commons.types.provider_credentialing_span_id import ProviderCredentialingSpanId
from ....commons.types.regions import Regions
from ....commons.types.request_validation_error import RequestValidationError
from ....commons.types.unauthorized_error_message import UnauthorizedErrorMessage
from ....commons.types.unprocessable_entity_error_message import UnprocessableEntityErrorMessage
from .types.provider_credentialing_span import ProviderCredentialingSpan
from .types.provider_credentialing_span_page import ProviderCredentialingSpanPage

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawV2Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self,
        *,
        rendering_provider_id: uuid.UUID,
        contracting_provider_id: uuid.UUID,
        payer_uuid: uuid.UUID,
        regions: Regions,
        start_date: typing.Optional[dt.date] = OMIT,
        end_date: typing.Optional[dt.date] = OMIT,
        submitted_date: typing.Optional[dt.date] = OMIT,
        payer_loaded_date: typing.Optional[dt.date] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ProviderCredentialingSpan]:
        """
        Parameters
        ----------
        rendering_provider_id : uuid.UUID
            The ID of the rendering provider covered by the credentialing span.

        contracting_provider_id : uuid.UUID
            The ID of the practice location at which the rendering provider is covered by the credentialing span.

        payer_uuid : uuid.UUID
            The ID of the payer covered by the credentialing span.

        regions : Regions
            The states covered by the credentialing span. A span may be national and cover all states.

        start_date : typing.Optional[dt.date]
            Start date of the credentialing span.

        end_date : typing.Optional[dt.date]
            End date of the credentialing span.

        submitted_date : typing.Optional[dt.date]
            Date that the credential paperwork was submitted.

        payer_loaded_date : typing.Optional[dt.date]
            Date that the payer loaded the credentialing span into their system.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProviderCredentialingSpan]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/provider-credentialing-span/v2",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json={
                "rendering_provider_id": rendering_provider_id,
                "contracting_provider_id": contracting_provider_id,
                "payer_uuid": payer_uuid,
                "start_date": start_date,
                "end_date": end_date,
                "regions": regions,
                "submitted_date": submitted_date,
                "payer_loaded_date": payer_loaded_date,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ProviderCredentialingSpan,
                parse_obj_as(
                    type_=ProviderCredentialingSpan,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self,
        provider_credentialing_id: ProviderCredentialingSpanId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ProviderCredentialingSpan]:
        """
        Parameters
        ----------
        provider_credentialing_id : ProviderCredentialingSpanId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProviderCredentialingSpan]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/provider-credentialing-span/v2/{jsonable_encoder(provider_credentialing_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ProviderCredentialingSpan,
                parse_obj_as(
                    type_=ProviderCredentialingSpan,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_all(
        self,
        *,
        limit: typing.Optional[int] = None,
        page_token: typing.Optional[PageToken] = None,
        payer_uuid: typing.Optional[uuid.UUID] = None,
        provider_id: typing.Optional[uuid.UUID] = None,
        as_rendering_provider: typing.Optional[bool] = None,
        as_contracting_provider: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ProviderCredentialingSpanPage]:
        """
        Parameters
        ----------
        limit : typing.Optional[int]
            Maximum number of entities per page, defaults to 100.

        page_token : typing.Optional[PageToken]

        payer_uuid : typing.Optional[uuid.UUID]
            Filter by payer.

        provider_id : typing.Optional[uuid.UUID]
            Filter to a particular provider. Use in conjunction as_rendering_provider and as_contracting_provider.

        as_rendering_provider : typing.Optional[bool]
            Filter to credentialing spans where the provider is a rendering provider. To use this filter provider_id is required.

        as_contracting_provider : typing.Optional[bool]
            Filter to credentialing spans where the provider is a contracting provider. To use this filter provider_id is required.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProviderCredentialingSpanPage]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/provider-credentialing-span/v2",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "limit": limit,
                "page_token": page_token,
                "payer_uuid": payer_uuid,
                "provider_id": provider_id,
                "as_rendering_provider": as_rendering_provider,
                "as_contracting_provider": as_contracting_provider,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ProviderCredentialingSpanPage,
                parse_obj_as(
                    type_=ProviderCredentialingSpanPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnprocessableEntityError":
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnprocessableEntityErrorMessage,
                        parse_obj_as(
                            type_=UnprocessableEntityErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self,
        provider_credentialing_id: ProviderCredentialingSpanId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Soft deletes a credentialing span rate from the system.

        Parameters
        ----------
        provider_credentialing_id : ProviderCredentialingSpanId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/provider-credentialing-span/v2/{jsonable_encoder(provider_credentialing_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="DELETE",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return HttpResponse(response=_response, data=None)
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        provider_credentialing_id: ProviderCredentialingSpanId,
        *,
        contracting_provider_id: typing.Optional[uuid.UUID] = OMIT,
        payer_uuid: typing.Optional[uuid.UUID] = OMIT,
        start_date: typing.Optional[dt.date] = OMIT,
        end_date: typing.Optional[dt.date] = OMIT,
        regions: typing.Optional[Regions] = OMIT,
        submitted_date: typing.Optional[dt.date] = OMIT,
        payer_loaded_date: typing.Optional[dt.date] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ProviderCredentialingSpan]:
        """
        Parameters
        ----------
        provider_credentialing_id : ProviderCredentialingSpanId

        contracting_provider_id : typing.Optional[uuid.UUID]
            The ID of the practice location at which the rendering provider is covered by the credentialing span.

        payer_uuid : typing.Optional[uuid.UUID]
            The ID of the payer doing the credentialing.

        start_date : typing.Optional[dt.date]
            Start date of the credentialing span.

        end_date : typing.Optional[dt.date]
            End date of the credentialing span.

        regions : typing.Optional[Regions]
            The states covered by the credentialing span. A span may be national and cover all states.

        submitted_date : typing.Optional[dt.date]
            Date that the credential paperwork was submitted.

        payer_loaded_date : typing.Optional[dt.date]
            Date that the payer loaded the credentialing span into their system.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProviderCredentialingSpan]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/provider-credentialing-span/v2/{jsonable_encoder(provider_credentialing_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json={
                "contracting_provider_id": contracting_provider_id,
                "payer_uuid": payer_uuid,
                "start_date": start_date,
                "end_date": end_date,
                "regions": regions,
                "submitted_date": submitted_date,
                "payer_loaded_date": payer_loaded_date,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ProviderCredentialingSpan,
                parse_obj_as(
                    type_=ProviderCredentialingSpan,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnprocessableEntityError":
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnprocessableEntityErrorMessage,
                        parse_obj_as(
                            type_=UnprocessableEntityErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawV2Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self,
        *,
        rendering_provider_id: uuid.UUID,
        contracting_provider_id: uuid.UUID,
        payer_uuid: uuid.UUID,
        regions: Regions,
        start_date: typing.Optional[dt.date] = OMIT,
        end_date: typing.Optional[dt.date] = OMIT,
        submitted_date: typing.Optional[dt.date] = OMIT,
        payer_loaded_date: typing.Optional[dt.date] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ProviderCredentialingSpan]:
        """
        Parameters
        ----------
        rendering_provider_id : uuid.UUID
            The ID of the rendering provider covered by the credentialing span.

        contracting_provider_id : uuid.UUID
            The ID of the practice location at which the rendering provider is covered by the credentialing span.

        payer_uuid : uuid.UUID
            The ID of the payer covered by the credentialing span.

        regions : Regions
            The states covered by the credentialing span. A span may be national and cover all states.

        start_date : typing.Optional[dt.date]
            Start date of the credentialing span.

        end_date : typing.Optional[dt.date]
            End date of the credentialing span.

        submitted_date : typing.Optional[dt.date]
            Date that the credential paperwork was submitted.

        payer_loaded_date : typing.Optional[dt.date]
            Date that the payer loaded the credentialing span into their system.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProviderCredentialingSpan]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/provider-credentialing-span/v2",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json={
                "rendering_provider_id": rendering_provider_id,
                "contracting_provider_id": contracting_provider_id,
                "payer_uuid": payer_uuid,
                "start_date": start_date,
                "end_date": end_date,
                "regions": regions,
                "submitted_date": submitted_date,
                "payer_loaded_date": payer_loaded_date,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ProviderCredentialingSpan,
                parse_obj_as(
                    type_=ProviderCredentialingSpan,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self,
        provider_credentialing_id: ProviderCredentialingSpanId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ProviderCredentialingSpan]:
        """
        Parameters
        ----------
        provider_credentialing_id : ProviderCredentialingSpanId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProviderCredentialingSpan]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/provider-credentialing-span/v2/{jsonable_encoder(provider_credentialing_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ProviderCredentialingSpan,
                parse_obj_as(
                    type_=ProviderCredentialingSpan,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_all(
        self,
        *,
        limit: typing.Optional[int] = None,
        page_token: typing.Optional[PageToken] = None,
        payer_uuid: typing.Optional[uuid.UUID] = None,
        provider_id: typing.Optional[uuid.UUID] = None,
        as_rendering_provider: typing.Optional[bool] = None,
        as_contracting_provider: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ProviderCredentialingSpanPage]:
        """
        Parameters
        ----------
        limit : typing.Optional[int]
            Maximum number of entities per page, defaults to 100.

        page_token : typing.Optional[PageToken]

        payer_uuid : typing.Optional[uuid.UUID]
            Filter by payer.

        provider_id : typing.Optional[uuid.UUID]
            Filter to a particular provider. Use in conjunction as_rendering_provider and as_contracting_provider.

        as_rendering_provider : typing.Optional[bool]
            Filter to credentialing spans where the provider is a rendering provider. To use this filter provider_id is required.

        as_contracting_provider : typing.Optional[bool]
            Filter to credentialing spans where the provider is a contracting provider. To use this filter provider_id is required.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProviderCredentialingSpanPage]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/provider-credentialing-span/v2",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "limit": limit,
                "page_token": page_token,
                "payer_uuid": payer_uuid,
                "provider_id": provider_id,
                "as_rendering_provider": as_rendering_provider,
                "as_contracting_provider": as_contracting_provider,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ProviderCredentialingSpanPage,
                parse_obj_as(
                    type_=ProviderCredentialingSpanPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnprocessableEntityError":
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnprocessableEntityErrorMessage,
                        parse_obj_as(
                            type_=UnprocessableEntityErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self,
        provider_credentialing_id: ProviderCredentialingSpanId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Soft deletes a credentialing span rate from the system.

        Parameters
        ----------
        provider_credentialing_id : ProviderCredentialingSpanId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/provider-credentialing-span/v2/{jsonable_encoder(provider_credentialing_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="DELETE",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return AsyncHttpResponse(response=_response, data=None)
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        provider_credentialing_id: ProviderCredentialingSpanId,
        *,
        contracting_provider_id: typing.Optional[uuid.UUID] = OMIT,
        payer_uuid: typing.Optional[uuid.UUID] = OMIT,
        start_date: typing.Optional[dt.date] = OMIT,
        end_date: typing.Optional[dt.date] = OMIT,
        regions: typing.Optional[Regions] = OMIT,
        submitted_date: typing.Optional[dt.date] = OMIT,
        payer_loaded_date: typing.Optional[dt.date] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ProviderCredentialingSpan]:
        """
        Parameters
        ----------
        provider_credentialing_id : ProviderCredentialingSpanId

        contracting_provider_id : typing.Optional[uuid.UUID]
            The ID of the practice location at which the rendering provider is covered by the credentialing span.

        payer_uuid : typing.Optional[uuid.UUID]
            The ID of the payer doing the credentialing.

        start_date : typing.Optional[dt.date]
            Start date of the credentialing span.

        end_date : typing.Optional[dt.date]
            End date of the credentialing span.

        regions : typing.Optional[Regions]
            The states covered by the credentialing span. A span may be national and cover all states.

        submitted_date : typing.Optional[dt.date]
            Date that the credential paperwork was submitted.

        payer_loaded_date : typing.Optional[dt.date]
            Date that the payer loaded the credentialing span into their system.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProviderCredentialingSpan]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/provider-credentialing-span/v2/{jsonable_encoder(provider_credentialing_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json={
                "contracting_provider_id": contracting_provider_id,
                "payer_uuid": payer_uuid,
                "start_date": start_date,
                "end_date": end_date,
                "regions": regions,
                "submitted_date": submitted_date,
                "payer_loaded_date": payer_loaded_date,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ProviderCredentialingSpan,
                parse_obj_as(
                    type_=ProviderCredentialingSpan,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnprocessableEntityError":
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnprocessableEntityErrorMessage,
                        parse_obj_as(
                            type_=UnprocessableEntityErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
