# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
import uuid

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....commons.types.regions import Regions
from .....organization_providers.resources.v_3.types.organization_provider_v_2 import OrganizationProviderV2
from .....payers.resources.v_3.types.payer import Payer
from .credentialing_span_status import CredentialingSpanStatus
from .provider_credentialing_span_id import ProviderCredentialingSpanId


class ProviderCredentialingSpan(UniversalBaseModel):
    provider_credentialing_span_id: ProviderCredentialingSpanId
    rendering_provider: OrganizationProviderV2 = pydantic.Field()
    """
    The rendering provider covered by the credentialing span.
    """

    contracting_provider: OrganizationProviderV2 = pydantic.Field()
    """
    The practice location at which the rendering provider is covered by the credentialing span.
    """

    payer: Payer = pydantic.Field()
    """
    The payer doing the credentialing.
    """

    start_date: typing.Optional[dt.date] = pydantic.Field(default=None)
    """
    Start date of the credentialing span.
    """

    end_date: typing.Optional[dt.date] = pydantic.Field(default=None)
    """
    End date of the credentialing span.
    """

    regions: Regions = pydantic.Field()
    """
    The states covered by the credentialing span. A span may be national and cover all states.
    """

    submitted_date: typing.Optional[dt.date] = pydantic.Field(default=None)
    """
    Date that the credential paperwork was submitted.
    """

    credentialing_status: CredentialingSpanStatus = pydantic.Field()
    """
    Status of the credentialing span.
    """

    payer_loaded_date: typing.Optional[dt.date] = pydantic.Field(default=None)
    """
    Date that the payer loaded the credentialing span into their system.
    """

    source: str = pydantic.Field()
    """
    Source of the credentialing span.
    """

    medallion_payer_enrollment_id: typing.Optional[uuid.UUID] = pydantic.Field(default=None)
    """
    Provider ID for the related medallion payer enrollment.
    """

    is_enabled: bool = pydantic.Field()
    """
    Is the credentialing span enabled?
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
