# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ....commons.types.schema_id import SchemaId
from .raw_client import AsyncRawV1Client, RawV1Client
from .types.schema import Schema
from .types.schema_field import SchemaField
from .types.schema_get_multi_response import SchemaGetMultiResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV1Client
        """
        return self._raw_client

    def get_multi(self, *, request_options: typing.Optional[RequestOptions] = None) -> SchemaGetMultiResponse:
        """
        Returns all custom schemas.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SchemaGetMultiResponse

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.custom_schemas.v_1.get_multi()
        """
        _response = self._raw_client.get_multi(request_options=request_options)
        return _response.data

    def get(self, schema_id: SchemaId, *, request_options: typing.Optional[RequestOptions] = None) -> Schema:
        """
        Return a custom schema with a given ID.

        Parameters
        ----------
        schema_id : SchemaId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Schema

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.custom_schemas.v_1.get(
            schema_id=uuid.UUID(
                "ec096b13-f80a-471d-aaeb-54b021c9d582",
            ),
        )
        """
        _response = self._raw_client.get(schema_id, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        name: str,
        fields: typing.Sequence[SchemaField],
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Schema:
        """
        Create custom schema with a set of typed keys. Schema keys can be referenced as inputs in user-configurable rules in the Rules
        Engine, and key-value pairs can be attached to claims via the Encounters API.

        Parameters
        ----------
        name : str

        fields : typing.Sequence[SchemaField]

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Schema

        Examples
        --------
        from candid import CandidApiClient
        from candid.resources.commons import Primitive
        from candid.resources.custom_schemas.resources.v_1 import SchemaField

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.custom_schemas.v_1.create(
            name="General Medicine",
            description="Values associated with a generic visit",
            fields=[
                SchemaField(
                    key="provider_category",
                    type=Primitive.STRING,
                ),
                SchemaField(
                    key="is_urgent_care",
                    type=Primitive.BOOLEAN,
                ),
                SchemaField(
                    key="bmi",
                    type=Primitive.DOUBLE,
                ),
                SchemaField(
                    key="age",
                    type=Primitive.INTEGER,
                ),
            ],
        )
        """
        _response = self._raw_client.create(
            name=name, fields=fields, description=description, request_options=request_options
        )
        return _response.data

    def update(
        self,
        schema_id: SchemaId,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        fields_to_add: typing.Optional[typing.Sequence[SchemaField]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Schema:
        """
        Update the name, description, or keys on a preexisting schema.

        Parameters
        ----------
        schema_id : SchemaId

        name : typing.Optional[str]

        description : typing.Optional[str]

        fields_to_add : typing.Optional[typing.Sequence[SchemaField]]
            A list of typed entries to add to schema. Only additive modifications are permitted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Schema

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.commons import Primitive
        from candid.resources.custom_schemas.resources.v_1 import SchemaField

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.custom_schemas.v_1.update(
            schema_id=uuid.UUID(
                "ec096b13-f80a-471d-aaeb-54b021c9d582",
            ),
            name="General Medicine and Health",
            description="Values collected during all visits",
            fields_to_add=[
                SchemaField(
                    key="visit_type",
                    type=Primitive.STRING,
                )
            ],
        )
        """
        _response = self._raw_client.update(
            schema_id, name=name, description=description, fields_to_add=fields_to_add, request_options=request_options
        )
        return _response.data


class AsyncV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV1Client
        """
        return self._raw_client

    async def get_multi(self, *, request_options: typing.Optional[RequestOptions] = None) -> SchemaGetMultiResponse:
        """
        Returns all custom schemas.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SchemaGetMultiResponse

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.custom_schemas.v_1.get_multi()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_multi(request_options=request_options)
        return _response.data

    async def get(self, schema_id: SchemaId, *, request_options: typing.Optional[RequestOptions] = None) -> Schema:
        """
        Return a custom schema with a given ID.

        Parameters
        ----------
        schema_id : SchemaId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Schema

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.custom_schemas.v_1.get(
                schema_id=uuid.UUID(
                    "ec096b13-f80a-471d-aaeb-54b021c9d582",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(schema_id, request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        name: str,
        fields: typing.Sequence[SchemaField],
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Schema:
        """
        Create custom schema with a set of typed keys. Schema keys can be referenced as inputs in user-configurable rules in the Rules
        Engine, and key-value pairs can be attached to claims via the Encounters API.

        Parameters
        ----------
        name : str

        fields : typing.Sequence[SchemaField]

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Schema

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient
        from candid.resources.commons import Primitive
        from candid.resources.custom_schemas.resources.v_1 import SchemaField

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.custom_schemas.v_1.create(
                name="General Medicine",
                description="Values associated with a generic visit",
                fields=[
                    SchemaField(
                        key="provider_category",
                        type=Primitive.STRING,
                    ),
                    SchemaField(
                        key="is_urgent_care",
                        type=Primitive.BOOLEAN,
                    ),
                    SchemaField(
                        key="bmi",
                        type=Primitive.DOUBLE,
                    ),
                    SchemaField(
                        key="age",
                        type=Primitive.INTEGER,
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name, fields=fields, description=description, request_options=request_options
        )
        return _response.data

    async def update(
        self,
        schema_id: SchemaId,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        fields_to_add: typing.Optional[typing.Sequence[SchemaField]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Schema:
        """
        Update the name, description, or keys on a preexisting schema.

        Parameters
        ----------
        schema_id : SchemaId

        name : typing.Optional[str]

        description : typing.Optional[str]

        fields_to_add : typing.Optional[typing.Sequence[SchemaField]]
            A list of typed entries to add to schema. Only additive modifications are permitted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Schema

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.commons import Primitive
        from candid.resources.custom_schemas.resources.v_1 import SchemaField

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.custom_schemas.v_1.update(
                schema_id=uuid.UUID(
                    "ec096b13-f80a-471d-aaeb-54b021c9d582",
                ),
                name="General Medicine and Health",
                description="Values collected during all visits",
                fields_to_add=[
                    SchemaField(
                        key="visit_type",
                        type=Primitive.STRING,
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            schema_id, name=name, description=description, fields_to_add=fields_to_add, request_options=request_options
        )
        return _response.data
