# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..yes_no_indicator.types.yes_no_indicator import YesNoIndicator
from .raw_client import AsyncRawDiagnosesClient, RawDiagnosesClient
from .types.diagnosis import Diagnosis
from .types.diagnosis_id import DiagnosisId
from .types.diagnosis_type_code import DiagnosisTypeCode
from .types.standalone_diagnosis_create import StandaloneDiagnosisCreate

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DiagnosesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDiagnosesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDiagnosesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDiagnosesClient
        """
        return self._raw_client

    def create(
        self, *, request: StandaloneDiagnosisCreate, request_options: typing.Optional[RequestOptions] = None
    ) -> Diagnosis:
        """
        Creates a new diagnosis for an encounter

        Parameters
        ----------
        request : StandaloneDiagnosisCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Diagnosis

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.diagnoses import (
            DiagnosisTypeCode,
            StandaloneDiagnosisCreate,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.diagnoses.create(
            request=StandaloneDiagnosisCreate(
                code_type=DiagnosisTypeCode.ABF,
                code="code",
                encounter_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def update(
        self,
        diagnosis_id: DiagnosisId,
        *,
        name: typing.Optional[str] = OMIT,
        code_type: typing.Optional[DiagnosisTypeCode] = OMIT,
        code: typing.Optional[str] = OMIT,
        present_on_admission_indicator: typing.Optional[YesNoIndicator] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Diagnosis:
        """
        Updates the diagnosis record matching the provided `diagnosis_id`

        Parameters
        ----------
        diagnosis_id : DiagnosisId

        name : typing.Optional[str]
            Empty string not allowed.

        code_type : typing.Optional[DiagnosisTypeCode]
            Typically, providers submitting claims to Candid are using ICD-10 diagnosis codes. If you are using ICD-10 codes, the primary diagnosis code listed on the claim should use the ABK code_type. If more than one diagnosis is being submitted on a claim, please use ABF for the rest of the listed diagnoses. If you are using ICD-9 diagnosis codes, use BK and BF for the principal and following diagnosis code(s) respectively.

        code : typing.Optional[str]
            Empty string not allowed.
            Should be of the appropriate format for the provided `code_type`.
            Must obey the ICD-10 format if an ICD-10 code_type is provided, specifically:
              - Letter
              - Digit
              - Digit or the letter `A` or `B`
              - (Optional) Period `.`
              - Up to 4 (or as few as 0) letters and digits

        present_on_admission_indicator : typing.Optional[YesNoIndicator]
            For Institutional claims only.
            A "Y" indicates that the onset occurred prior to admission to the hospital.
            An "N" indicates that the onset did NOT occur prior to admission to the hospital.
            A "U" indicates that it is unknown whether the onset occurred prior to admission to the hospital or not.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Diagnosis

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.diagnoses.update(
            diagnosis_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.update(
            diagnosis_id,
            name=name,
            code_type=code_type,
            code=code,
            present_on_admission_indicator=present_on_admission_indicator,
            request_options=request_options,
        )
        return _response.data

    def delete(self, diagnosis_id: DiagnosisId, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Deletes the diagnosis record associated with the provided `diagnosis_id`

        Parameters
        ----------
        diagnosis_id : DiagnosisId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.diagnoses.delete(
            diagnosis_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.delete(diagnosis_id, request_options=request_options)
        return _response.data


class AsyncDiagnosesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDiagnosesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDiagnosesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDiagnosesClient
        """
        return self._raw_client

    async def create(
        self, *, request: StandaloneDiagnosisCreate, request_options: typing.Optional[RequestOptions] = None
    ) -> Diagnosis:
        """
        Creates a new diagnosis for an encounter

        Parameters
        ----------
        request : StandaloneDiagnosisCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Diagnosis

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.diagnoses import (
            DiagnosisTypeCode,
            StandaloneDiagnosisCreate,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.diagnoses.create(
                request=StandaloneDiagnosisCreate(
                    code_type=DiagnosisTypeCode.ABF,
                    code="code",
                    encounter_id=uuid.UUID(
                        "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def update(
        self,
        diagnosis_id: DiagnosisId,
        *,
        name: typing.Optional[str] = OMIT,
        code_type: typing.Optional[DiagnosisTypeCode] = OMIT,
        code: typing.Optional[str] = OMIT,
        present_on_admission_indicator: typing.Optional[YesNoIndicator] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Diagnosis:
        """
        Updates the diagnosis record matching the provided `diagnosis_id`

        Parameters
        ----------
        diagnosis_id : DiagnosisId

        name : typing.Optional[str]
            Empty string not allowed.

        code_type : typing.Optional[DiagnosisTypeCode]
            Typically, providers submitting claims to Candid are using ICD-10 diagnosis codes. If you are using ICD-10 codes, the primary diagnosis code listed on the claim should use the ABK code_type. If more than one diagnosis is being submitted on a claim, please use ABF for the rest of the listed diagnoses. If you are using ICD-9 diagnosis codes, use BK and BF for the principal and following diagnosis code(s) respectively.

        code : typing.Optional[str]
            Empty string not allowed.
            Should be of the appropriate format for the provided `code_type`.
            Must obey the ICD-10 format if an ICD-10 code_type is provided, specifically:
              - Letter
              - Digit
              - Digit or the letter `A` or `B`
              - (Optional) Period `.`
              - Up to 4 (or as few as 0) letters and digits

        present_on_admission_indicator : typing.Optional[YesNoIndicator]
            For Institutional claims only.
            A "Y" indicates that the onset occurred prior to admission to the hospital.
            An "N" indicates that the onset did NOT occur prior to admission to the hospital.
            A "U" indicates that it is unknown whether the onset occurred prior to admission to the hospital or not.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Diagnosis

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.diagnoses.update(
                diagnosis_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            diagnosis_id,
            name=name,
            code_type=code_type,
            code=code,
            present_on_admission_indicator=present_on_admission_indicator,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self, diagnosis_id: DiagnosisId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Deletes the diagnosis record associated with the provided `diagnosis_id`

        Parameters
        ----------
        diagnosis_id : DiagnosisId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.diagnoses.delete(
                diagnosis_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(diagnosis_id, request_options=request_options)
        return _response.data
