# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...yes_no_indicator.types.yes_no_indicator import YesNoIndicator
from .diagnosis_type_code import DiagnosisTypeCode


class DiagnosisCreate(UniversalBaseModel):
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Empty string not allowed.
    """

    code_type: DiagnosisTypeCode = pydantic.Field()
    """
    Typically, providers submitting claims to Candid are using ICD-10 diagnosis codes. If you are using ICD-10 codes, the primary diagnosis code listed on the claim should use the ABK code_type. If more than one diagnosis is being submitted on a claim, please use ABF for the rest of the listed diagnoses. If you are using ICD-9 diagnosis codes, use BK and BF for the principal and following diagnosis code(s) respectively.
    """

    code: str = pydantic.Field()
    """
    Empty string not allowed.
    Should be of the appropriate format for the provided `code_type`.
    Must obey the ICD-10 format if an ICD-10 code_type is provided, specifically:
      - Letter
      - Digit
      - Digit or the letter `A` or `B`
      - (Optional) Period `.`
      - Up to 4 (or as few as 0) letters and digits
    """

    present_on_admission_indicator: typing.Optional[YesNoIndicator] = pydantic.Field(default=None)
    """
    For Institutional claims only.
    A "Y" indicates that the onset occurred prior to admission to the hospital.
    An "N" indicates that the onset did NOT occur prior to admission to the hospital.
    A "U" indicates that it is unknown whether the onset occurred prior to admission to the hospital or not.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
