# This file was auto-generated by Fern from our API Definition.

import typing

from ..... import core
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ....commons.types.encounter_id import EncounterId
from .raw_client import AsyncRawV1Client, RawV1Client
from .types.attachment_id import AttachmentId
from .types.encounter_attachment import EncounterAttachment
from .types.encounter_attachment_type import EncounterAttachmentType

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV1Client
        """
        return self._raw_client

    def get(
        self, encounter_id: EncounterId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[EncounterAttachment]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[EncounterAttachment]

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.encounter_attachments.v_1.get(
            encounter_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.get(encounter_id, request_options=request_options)
        return _response.data

    def create(
        self,
        encounter_id: EncounterId,
        *,
        attachment_file: core.File,
        attachment_type: EncounterAttachmentType,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AttachmentId:
        """
        Uploads a file to the encounter. The file will be stored in the
        encounter's attachments.

        Parameters
        ----------
        encounter_id : EncounterId

        attachment_file : core.File
            See core.File for more documentation

        attachment_type : EncounterAttachmentType

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AttachmentId
        """
        _response = self._raw_client.create(
            encounter_id,
            attachment_file=attachment_file,
            attachment_type=attachment_type,
            request_options=request_options,
        )
        return _response.data

    def delete(
        self,
        encounter_id: EncounterId,
        *,
        attachment_id: AttachmentId,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        attachment_id : AttachmentId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.encounter_attachments.v_1.delete(
            encounter_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            attachment_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.delete(encounter_id, attachment_id=attachment_id, request_options=request_options)
        return _response.data


class AsyncV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV1Client
        """
        return self._raw_client

    async def get(
        self, encounter_id: EncounterId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[EncounterAttachment]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[EncounterAttachment]

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.encounter_attachments.v_1.get(
                encounter_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(encounter_id, request_options=request_options)
        return _response.data

    async def create(
        self,
        encounter_id: EncounterId,
        *,
        attachment_file: core.File,
        attachment_type: EncounterAttachmentType,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AttachmentId:
        """
        Uploads a file to the encounter. The file will be stored in the
        encounter's attachments.

        Parameters
        ----------
        encounter_id : EncounterId

        attachment_file : core.File
            See core.File for more documentation

        attachment_type : EncounterAttachmentType

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AttachmentId
        """
        _response = await self._raw_client.create(
            encounter_id,
            attachment_file=attachment_file,
            attachment_type=attachment_type,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self,
        encounter_id: EncounterId,
        *,
        attachment_id: AttachmentId,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        attachment_id : AttachmentId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.encounter_attachments.v_1.delete(
                encounter_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                attachment_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(
            encounter_id, attachment_id=attachment_id, request_options=request_options
        )
        return _response.data
