# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ....commons.types.encounter_id import EncounterId
from ....commons.types.service_line_id import ServiceLineId
from .raw_client import AsyncRawV2Client, RawV2Client
from .types.encounter_provider import EncounterProvider
from .types.initial_referring_provider import InitialReferringProvider
from .types.initial_referring_provider_update import InitialReferringProviderUpdate
from .types.ordering_provider import OrderingProvider
from .types.ordering_provider_update import OrderingProviderUpdate
from .types.referring_provider import ReferringProvider
from .types.referring_provider_update import ReferringProviderUpdate
from .types.supervising_provider import SupervisingProvider
from .types.supervising_provider_update import SupervisingProviderUpdate

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V2Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV2Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV2Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV2Client
        """
        return self._raw_client

    def update_referring_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: ReferringProviderUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EncounterProvider:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : ReferringProviderUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EncounterProvider

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.encounter_providers.resources.v_2 import (
            ReferringProviderUpdate,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.encounter_providers.v_2.update_referring_provider(
            encounter_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            request=ReferringProviderUpdate(),
        )
        """
        _response = self._raw_client.update_referring_provider(
            encounter_id, request=request, request_options=request_options
        )
        return _response.data

    def update_initial_referring_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: InitialReferringProviderUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EncounterProvider:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : InitialReferringProviderUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EncounterProvider

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.encounter_providers.resources.v_2 import (
            InitialReferringProviderUpdate,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.encounter_providers.v_2.update_initial_referring_provider(
            encounter_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            request=InitialReferringProviderUpdate(),
        )
        """
        _response = self._raw_client.update_initial_referring_provider(
            encounter_id, request=request, request_options=request_options
        )
        return _response.data

    def update_supervising_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: SupervisingProviderUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EncounterProvider:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : SupervisingProviderUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EncounterProvider

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.encounter_providers.resources.v_2 import (
            SupervisingProviderUpdate,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.encounter_providers.v_2.update_supervising_provider(
            encounter_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            request=SupervisingProviderUpdate(),
        )
        """
        _response = self._raw_client.update_supervising_provider(
            encounter_id, request=request, request_options=request_options
        )
        return _response.data

    def update_ordering_provider(
        self,
        service_line_id: ServiceLineId,
        *,
        request: OrderingProviderUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EncounterProvider:
        """
        Parameters
        ----------
        service_line_id : ServiceLineId

        request : OrderingProviderUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EncounterProvider

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.encounter_providers.resources.v_2 import (
            OrderingProviderUpdate,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.encounter_providers.v_2.update_ordering_provider(
            service_line_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            request=OrderingProviderUpdate(),
        )
        """
        _response = self._raw_client.update_ordering_provider(
            service_line_id, request=request, request_options=request_options
        )
        return _response.data

    def create_referring_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: ReferringProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EncounterProvider:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : ReferringProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EncounterProvider

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.encounter_providers.resources.v_2 import ReferringProvider

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.encounter_providers.v_2.create_referring_provider(
            encounter_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            request=ReferringProvider(
                npi="npi",
            ),
        )
        """
        _response = self._raw_client.create_referring_provider(
            encounter_id, request=request, request_options=request_options
        )
        return _response.data

    def create_initial_referring_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: InitialReferringProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EncounterProvider:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : InitialReferringProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EncounterProvider

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.encounter_providers.resources.v_2 import (
            InitialReferringProvider,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.encounter_providers.v_2.create_initial_referring_provider(
            encounter_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            request=InitialReferringProvider(
                npi="npi",
            ),
        )
        """
        _response = self._raw_client.create_initial_referring_provider(
            encounter_id, request=request, request_options=request_options
        )
        return _response.data

    def create_supervising_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: SupervisingProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EncounterProvider:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : SupervisingProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EncounterProvider

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.encounter_providers.resources.v_2 import (
            SupervisingProvider,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.encounter_providers.v_2.create_supervising_provider(
            encounter_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            request=SupervisingProvider(
                npi="npi",
            ),
        )
        """
        _response = self._raw_client.create_supervising_provider(
            encounter_id, request=request, request_options=request_options
        )
        return _response.data

    def create_ordering_provider(
        self,
        service_line_id: ServiceLineId,
        *,
        request: OrderingProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EncounterProvider:
        """
        Parameters
        ----------
        service_line_id : ServiceLineId

        request : OrderingProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EncounterProvider

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.encounter_providers.resources.v_2 import OrderingProvider

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.encounter_providers.v_2.create_ordering_provider(
            service_line_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            request=OrderingProvider(
                npi="npi",
            ),
        )
        """
        _response = self._raw_client.create_ordering_provider(
            service_line_id, request=request, request_options=request_options
        )
        return _response.data

    def delete_referring_provider(
        self, encounter_id: EncounterId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.encounter_providers.v_2.delete_referring_provider(
            encounter_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.delete_referring_provider(encounter_id, request_options=request_options)
        return _response.data

    def delete_initial_referring_provider(
        self, encounter_id: EncounterId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.encounter_providers.v_2.delete_initial_referring_provider(
            encounter_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.delete_initial_referring_provider(encounter_id, request_options=request_options)
        return _response.data

    def delete_supervising_provider(
        self, encounter_id: EncounterId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.encounter_providers.v_2.delete_supervising_provider(
            encounter_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.delete_supervising_provider(encounter_id, request_options=request_options)
        return _response.data

    def delete_ordering_provider(
        self, service_line_id: ServiceLineId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        service_line_id : ServiceLineId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.encounter_providers.v_2.delete_ordering_provider(
            service_line_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.delete_ordering_provider(service_line_id, request_options=request_options)
        return _response.data


class AsyncV2Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV2Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV2Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV2Client
        """
        return self._raw_client

    async def update_referring_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: ReferringProviderUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EncounterProvider:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : ReferringProviderUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EncounterProvider

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.encounter_providers.resources.v_2 import (
            ReferringProviderUpdate,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.encounter_providers.v_2.update_referring_provider(
                encounter_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                request=ReferringProviderUpdate(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_referring_provider(
            encounter_id, request=request, request_options=request_options
        )
        return _response.data

    async def update_initial_referring_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: InitialReferringProviderUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EncounterProvider:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : InitialReferringProviderUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EncounterProvider

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.encounter_providers.resources.v_2 import (
            InitialReferringProviderUpdate,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.encounter_providers.v_2.update_initial_referring_provider(
                encounter_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                request=InitialReferringProviderUpdate(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_initial_referring_provider(
            encounter_id, request=request, request_options=request_options
        )
        return _response.data

    async def update_supervising_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: SupervisingProviderUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EncounterProvider:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : SupervisingProviderUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EncounterProvider

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.encounter_providers.resources.v_2 import (
            SupervisingProviderUpdate,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.encounter_providers.v_2.update_supervising_provider(
                encounter_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                request=SupervisingProviderUpdate(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_supervising_provider(
            encounter_id, request=request, request_options=request_options
        )
        return _response.data

    async def update_ordering_provider(
        self,
        service_line_id: ServiceLineId,
        *,
        request: OrderingProviderUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EncounterProvider:
        """
        Parameters
        ----------
        service_line_id : ServiceLineId

        request : OrderingProviderUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EncounterProvider

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.encounter_providers.resources.v_2 import (
            OrderingProviderUpdate,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.encounter_providers.v_2.update_ordering_provider(
                service_line_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                request=OrderingProviderUpdate(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_ordering_provider(
            service_line_id, request=request, request_options=request_options
        )
        return _response.data

    async def create_referring_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: ReferringProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EncounterProvider:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : ReferringProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EncounterProvider

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.encounter_providers.resources.v_2 import ReferringProvider

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.encounter_providers.v_2.create_referring_provider(
                encounter_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                request=ReferringProvider(
                    npi="npi",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_referring_provider(
            encounter_id, request=request, request_options=request_options
        )
        return _response.data

    async def create_initial_referring_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: InitialReferringProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EncounterProvider:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : InitialReferringProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EncounterProvider

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.encounter_providers.resources.v_2 import (
            InitialReferringProvider,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.encounter_providers.v_2.create_initial_referring_provider(
                encounter_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                request=InitialReferringProvider(
                    npi="npi",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_initial_referring_provider(
            encounter_id, request=request, request_options=request_options
        )
        return _response.data

    async def create_supervising_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: SupervisingProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EncounterProvider:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : SupervisingProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EncounterProvider

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.encounter_providers.resources.v_2 import (
            SupervisingProvider,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.encounter_providers.v_2.create_supervising_provider(
                encounter_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                request=SupervisingProvider(
                    npi="npi",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_supervising_provider(
            encounter_id, request=request, request_options=request_options
        )
        return _response.data

    async def create_ordering_provider(
        self,
        service_line_id: ServiceLineId,
        *,
        request: OrderingProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EncounterProvider:
        """
        Parameters
        ----------
        service_line_id : ServiceLineId

        request : OrderingProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EncounterProvider

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.encounter_providers.resources.v_2 import OrderingProvider

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.encounter_providers.v_2.create_ordering_provider(
                service_line_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                request=OrderingProvider(
                    npi="npi",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_ordering_provider(
            service_line_id, request=request, request_options=request_options
        )
        return _response.data

    async def delete_referring_provider(
        self, encounter_id: EncounterId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.encounter_providers.v_2.delete_referring_provider(
                encounter_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_referring_provider(encounter_id, request_options=request_options)
        return _response.data

    async def delete_initial_referring_provider(
        self, encounter_id: EncounterId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.encounter_providers.v_2.delete_initial_referring_provider(
                encounter_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_initial_referring_provider(
            encounter_id, request_options=request_options
        )
        return _response.data

    async def delete_supervising_provider(
        self, encounter_id: EncounterId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.encounter_providers.v_2.delete_supervising_provider(
                encounter_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_supervising_provider(encounter_id, request_options=request_options)
        return _response.data

    async def delete_ordering_provider(
        self, service_line_id: ServiceLineId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        service_line_id : ServiceLineId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.encounter_providers.v_2.delete_ordering_provider(
                service_line_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_ordering_provider(service_line_id, request_options=request_options)
        return _response.data
