# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.jsonable_encoder import jsonable_encoder
from .....core.pydantic_utilities import parse_obj_as
from .....core.request_options import RequestOptions
from ....commons.errors.entity_conflict_error import EntityConflictError
from ....commons.errors.entity_not_found_error import EntityNotFoundError
from ....commons.errors.http_request_validations_error import HttpRequestValidationsError
from ....commons.errors.unprocessable_entity_error import UnprocessableEntityError
from ....commons.types.encounter_id import EncounterId
from ....commons.types.entity_conflict_error_message import EntityConflictErrorMessage
from ....commons.types.entity_not_found_error_message import EntityNotFoundErrorMessage
from ....commons.types.request_validation_error import RequestValidationError
from ....commons.types.service_line_id import ServiceLineId
from ....commons.types.unprocessable_entity_error_message import UnprocessableEntityErrorMessage
from .types.encounter_provider import EncounterProvider
from .types.initial_referring_provider import InitialReferringProvider
from .types.initial_referring_provider_update import InitialReferringProviderUpdate
from .types.ordering_provider import OrderingProvider
from .types.ordering_provider_update import OrderingProviderUpdate
from .types.referring_provider import ReferringProvider
from .types.referring_provider_update import ReferringProviderUpdate
from .types.supervising_provider import SupervisingProvider
from .types.supervising_provider_update import SupervisingProviderUpdate

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawV2Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def update_referring_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: ReferringProviderUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[EncounterProvider]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : ReferringProviderUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EncounterProvider]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(encounter_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EncounterProvider,
                parse_obj_as(
                    type_=EncounterProvider,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_initial_referring_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: InitialReferringProviderUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[EncounterProvider]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : InitialReferringProviderUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EncounterProvider]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(encounter_id)}/initial-referring-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EncounterProvider,
                parse_obj_as(
                    type_=EncounterProvider,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_supervising_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: SupervisingProviderUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[EncounterProvider]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : SupervisingProviderUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EncounterProvider]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(encounter_id)}/supervising-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EncounterProvider,
                parse_obj_as(
                    type_=EncounterProvider,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_ordering_provider(
        self,
        service_line_id: ServiceLineId,
        *,
        request: OrderingProviderUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[EncounterProvider]:
        """
        Parameters
        ----------
        service_line_id : ServiceLineId

        request : OrderingProviderUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EncounterProvider]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(service_line_id)}/ordering-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EncounterProvider,
                parse_obj_as(
                    type_=EncounterProvider,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_referring_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: ReferringProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[EncounterProvider]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : ReferringProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EncounterProvider]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(encounter_id)}/create-referring-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EncounterProvider,
                parse_obj_as(
                    type_=EncounterProvider,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityConflictError":
                raise EntityConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityConflictErrorMessage,
                        parse_obj_as(
                            type_=EntityConflictErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_initial_referring_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: InitialReferringProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[EncounterProvider]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : InitialReferringProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EncounterProvider]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(encounter_id)}/create-initial-referring-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EncounterProvider,
                parse_obj_as(
                    type_=EncounterProvider,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityConflictError":
                raise EntityConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityConflictErrorMessage,
                        parse_obj_as(
                            type_=EntityConflictErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnprocessableEntityError":
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnprocessableEntityErrorMessage,
                        parse_obj_as(
                            type_=UnprocessableEntityErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_supervising_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: SupervisingProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[EncounterProvider]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : SupervisingProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EncounterProvider]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(encounter_id)}/create-supervising-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EncounterProvider,
                parse_obj_as(
                    type_=EncounterProvider,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityConflictError":
                raise EntityConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityConflictErrorMessage,
                        parse_obj_as(
                            type_=EntityConflictErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_ordering_provider(
        self,
        service_line_id: ServiceLineId,
        *,
        request: OrderingProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[EncounterProvider]:
        """
        Parameters
        ----------
        service_line_id : ServiceLineId

        request : OrderingProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EncounterProvider]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(service_line_id)}/create-ordering-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EncounterProvider,
                parse_obj_as(
                    type_=EncounterProvider,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityConflictError":
                raise EntityConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityConflictErrorMessage,
                        parse_obj_as(
                            type_=EntityConflictErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_referring_provider(
        self, encounter_id: EncounterId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(encounter_id)}/referring-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="DELETE",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return HttpResponse(response=_response, data=None)
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityConflictError":
                raise EntityConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityConflictErrorMessage,
                        parse_obj_as(
                            type_=EntityConflictErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_initial_referring_provider(
        self, encounter_id: EncounterId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(encounter_id)}/initial-referring-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="DELETE",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return HttpResponse(response=_response, data=None)
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_supervising_provider(
        self, encounter_id: EncounterId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(encounter_id)}/supervising-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="DELETE",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return HttpResponse(response=_response, data=None)
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_ordering_provider(
        self, service_line_id: ServiceLineId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        service_line_id : ServiceLineId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(service_line_id)}/ordering-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="DELETE",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return HttpResponse(response=_response, data=None)
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawV2Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def update_referring_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: ReferringProviderUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[EncounterProvider]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : ReferringProviderUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EncounterProvider]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(encounter_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EncounterProvider,
                parse_obj_as(
                    type_=EncounterProvider,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_initial_referring_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: InitialReferringProviderUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[EncounterProvider]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : InitialReferringProviderUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EncounterProvider]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(encounter_id)}/initial-referring-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EncounterProvider,
                parse_obj_as(
                    type_=EncounterProvider,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_supervising_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: SupervisingProviderUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[EncounterProvider]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : SupervisingProviderUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EncounterProvider]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(encounter_id)}/supervising-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EncounterProvider,
                parse_obj_as(
                    type_=EncounterProvider,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_ordering_provider(
        self,
        service_line_id: ServiceLineId,
        *,
        request: OrderingProviderUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[EncounterProvider]:
        """
        Parameters
        ----------
        service_line_id : ServiceLineId

        request : OrderingProviderUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EncounterProvider]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(service_line_id)}/ordering-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EncounterProvider,
                parse_obj_as(
                    type_=EncounterProvider,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_referring_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: ReferringProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[EncounterProvider]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : ReferringProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EncounterProvider]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(encounter_id)}/create-referring-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EncounterProvider,
                parse_obj_as(
                    type_=EncounterProvider,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityConflictError":
                raise EntityConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityConflictErrorMessage,
                        parse_obj_as(
                            type_=EntityConflictErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_initial_referring_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: InitialReferringProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[EncounterProvider]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : InitialReferringProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EncounterProvider]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(encounter_id)}/create-initial-referring-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EncounterProvider,
                parse_obj_as(
                    type_=EncounterProvider,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityConflictError":
                raise EntityConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityConflictErrorMessage,
                        parse_obj_as(
                            type_=EntityConflictErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnprocessableEntityError":
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnprocessableEntityErrorMessage,
                        parse_obj_as(
                            type_=UnprocessableEntityErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_supervising_provider(
        self,
        encounter_id: EncounterId,
        *,
        request: SupervisingProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[EncounterProvider]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request : SupervisingProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EncounterProvider]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(encounter_id)}/create-supervising-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EncounterProvider,
                parse_obj_as(
                    type_=EncounterProvider,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityConflictError":
                raise EntityConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityConflictErrorMessage,
                        parse_obj_as(
                            type_=EntityConflictErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_ordering_provider(
        self,
        service_line_id: ServiceLineId,
        *,
        request: OrderingProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[EncounterProvider]:
        """
        Parameters
        ----------
        service_line_id : ServiceLineId

        request : OrderingProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EncounterProvider]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(service_line_id)}/create-ordering-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EncounterProvider,
                parse_obj_as(
                    type_=EncounterProvider,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityConflictError":
                raise EntityConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityConflictErrorMessage,
                        parse_obj_as(
                            type_=EntityConflictErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_referring_provider(
        self, encounter_id: EncounterId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(encounter_id)}/referring-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="DELETE",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return AsyncHttpResponse(response=_response, data=None)
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityConflictError":
                raise EntityConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityConflictErrorMessage,
                        parse_obj_as(
                            type_=EntityConflictErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_initial_referring_provider(
        self, encounter_id: EncounterId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(encounter_id)}/initial-referring-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="DELETE",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return AsyncHttpResponse(response=_response, data=None)
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_supervising_provider(
        self, encounter_id: EncounterId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(encounter_id)}/supervising-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="DELETE",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return AsyncHttpResponse(response=_response, data=None)
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_ordering_provider(
        self, service_line_id: ServiceLineId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        service_line_id : ServiceLineId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/encounter-providers/v2/{jsonable_encoder(service_line_id)}/ordering-provider",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="DELETE",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return AsyncHttpResponse(response=_response, data=None)
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
