# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2
from .....commons.types.billing_provider_commercial_license_type import BillingProviderCommercialLicenseType
from .....commons.types.street_address_short_zip_optional import StreetAddressShortZipOptional
from .encounter_provider_base import EncounterProviderBase


class BillingProviderUpdateWithOptionalAddress(EncounterProviderBase):
    """
    The billing provider is the provider or business entity submitting the claim.
    Billing provider may be, but is not necessarily, the same person/NPI as the rendering provider.
    From a payer's perspective, this represents the person or entity being reimbursed.
    When a contract exists with the target payer, the billing provider should be the entity contracted with the payer.
    In some circumstances, this will be an individual provider. In that case, submit that provider's NPI and the
    tax ID (TIN) that the provider gave to the payer during contracting.
    In other cases, the billing entity will be a medical group. If so, submit the group NPI and the group's tax ID.
    Box 33 on the CMS-1500 claim form.
    The address fields here are optional.
    """

    address: typing.Optional[StreetAddressShortZipOptional] = None
    tax_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    If the provider has a contract with insurance, this must be the same tax ID given to the payer on an IRS W-9 form completed during contracting.
    """

    npi: typing.Optional[str] = None
    taxonomy_code: typing.Optional[str] = None
    provider_commercial_license_type: typing.Optional[BillingProviderCommercialLicenseType] = pydantic.Field(
        default=None
    )
    """
    837i Loop2010BB G2
    Provider Commercial Number
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
