# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2
from .....commons.types.billing_provider_commercial_license_type import BillingProviderCommercialLicenseType
from .....commons.types.qualifier_code import QualifierCode
from .....commons.types.street_address_long_zip import StreetAddressLongZip
from .encounter_provider_base import EncounterProviderBase
from .provider_id import ProviderId


class EncounterProvider(EncounterProviderBase):
    """
    Examples
    --------
    import uuid

    from candid.resources.commons import State, StreetAddressLongZip
    from candid.resources.encounter_providers.resources.v_2 import EncounterProvider

    EncounterProvider(
        provider_id=uuid.UUID(
            "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
        ),
        address=StreetAddressLongZip(
            address_1="123 Main St",
            address_2="Apt 1",
            city="New York",
            state=State.NY,
            zip_code="10001",
            zip_plus_four_code="1234",
        ),
        tax_id="123456789",
        npi="1234567890",
        taxonomy_code="207Q00000X",
        first_name="John",
        last_name="Doe",
        organization_name="Organization Name",
    )
    """

    provider_id: ProviderId
    address: StreetAddressLongZip
    tax_id: typing.Optional[str] = None
    npi: str
    taxonomy_code: typing.Optional[str] = None
    qualifier: typing.Optional[QualifierCode] = None
    provider_commercial_license_type: typing.Optional[BillingProviderCommercialLicenseType] = pydantic.Field(
        default=None
    )
    """
    837i Loop2010BB G2
    Provider Commercial Number
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
