# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2
from .....commons.types.qualifier_code import QualifierCode
from .....commons.types.street_address_long_zip import StreetAddressLongZip
from .encounter_provider_base import EncounterProviderBase


class InitialReferringProvider(EncounterProviderBase):
    npi: str = pydantic.Field()
    """
    A National Provider Identifier is a unique 10-digit identification
    number issued to health care providers in the United States
    """

    taxonomy_code: typing.Optional[str] = None
    address: typing.Optional[StreetAddressLongZip] = None
    qualifier: typing.Optional[QualifierCode] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
