# This file was auto-generated by Fern from our API Definition.

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawEncountersClient, RawEncountersClient
from .resources.v_4.client import AsyncV4Client, V4Client


class EncountersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEncountersClient(client_wrapper=client_wrapper)
        self.v_4 = V4Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawEncountersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEncountersClient
        """
        return self._raw_client


class AsyncEncountersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEncountersClient(client_wrapper=client_wrapper)
        self.v_4 = AsyncV4Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEncountersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEncountersClient
        """
        return self._raw_client
