# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .clinical_note import ClinicalNote
from .note_category import NoteCategory


class ClinicalNoteCategory(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from candid.resources.encounters.resources.v_4 import (
        ClinicalNote,
        ClinicalNoteCategory,
        NoteCategory,
    )

    ClinicalNoteCategory(
        category=NoteCategory.CLINICAL,
        notes=["Patient complained of mild chest pain."],
        notes_structured=[
            ClinicalNote(
                text="Mild chest pain since morning.",
                author_name="John Doe",
                author_npi="1234567890",
                timestamp=datetime.datetime.fromisoformat(
                    "2023-01-01 00:00:00+00:00",
                ),
            )
        ],
    )
    """

    category: NoteCategory
    notes: typing.List[str]
    notes_structured: typing.Optional[typing.List[ClinicalNote]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
