# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....commons.types.delay_reason_code import DelayReasonCode
from .....commons.types.encounter_external_id import EncounterExternalId
from .....commons.types.facility_type_code import FacilityTypeCode
from .....tags.types.tag_id import TagId
from .billable_status_type import BillableStatusType
from .prior_authorization_number import PriorAuthorizationNumber
from .responsible_party_type import ResponsiblePartyType
from .service_authorization_exception_code import ServiceAuthorizationExceptionCode
from .synchronicity_type import SynchronicityType
from .vitals_update import VitalsUpdate


class EncounterOptional(UniversalBaseModel):
    benefits_assigned_to_provider: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this patient has authorized insurance payments to be made to you, not them. If false, patient may receive reimbursement. Box 13 on the CMS-1500 claim form.
    """

    prior_authorization_number: typing.Optional[PriorAuthorizationNumber] = pydantic.Field(default=None)
    """
    Box 23 on the CMS-1500 claim form.
    """

    external_id: typing.Optional[EncounterExternalId] = pydantic.Field(default=None)
    """
    A client-specified unique ID to associate with this encounter;
    for example, your internal encounter ID or a Dr. Chrono encounter ID.
    This field should not contain PHI.
    """

    date_of_service: typing.Optional[dt.date] = pydantic.Field(default=None)
    """
    Date formatted as YYYY-MM-DD; eg: 2019-08-24.
    This date must be the local date in the timezone where the service occurred.
    Box 24a on the CMS-1500 claim form.
    If service occurred over a range of dates, this should be the start date.
    If service lines have distinct date_of_service values, updating the encounter's date_of_service will fail. If all service line date_of_service values are the same, updating the encounter's date_of_service will update all service line date_of_service values.
    """

    tag_ids: typing.Optional[typing.List[TagId]] = pydantic.Field(default=None)
    """
    Names of tags that should be on the encounter.  Note all tags on encounter will be overridden with this list.
    """

    billable_status: typing.Optional[BillableStatusType] = pydantic.Field(default=None)
    """
    Defines if the Encounter is to be billed by Candid to the responsible_party. Examples for when this should be set to NOT_BILLABLE include if the Encounter has not occurred yet or if there is no intention of ever billing the responsible_party.
    """

    responsible_party: typing.Optional[ResponsiblePartyType] = pydantic.Field(default=None)
    """
    Defines the party to be billed with the initial balance owed on the claim. Use SELF_PAY if you intend to bill self pay/cash pay.
    """

    provider_accepts_assignment: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether you have accepted the patient's authorization for insurance payments to be made to you, not them. Box 27 on the CMS-1500 claim form.
    """

    synchronicity: typing.Optional[SynchronicityType] = pydantic.Field(default=None)
    """
    Whether or not this was a synchronous or asynchronous encounter. Asynchronous encounters occur when providers and patients communicate online using forms, instant messaging, or other pre-recorded digital mediums. Synchronous encounters occur in live, real-time settings where the patient interacts directly with the provider, such as over video or a phone call.
    """

    place_of_service_code: typing.Optional[FacilityTypeCode] = pydantic.Field(default=None)
    """
    Box 24B on the CMS-1500 claim form. 837p Loop2300, CLM-05-1. 02 for telemedicine, 11 for in-person. Full list [here](https://www.cms.gov/Medicare/Coding/place-of-service-codes/Place_of_Service_Code_Set).
    """

    appointment_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Human-readable description of the appointment type (ex: "Acupuncture - Headaches").
    """

    end_date_of_service: typing.Optional[dt.date] = pydantic.Field(default=None)
    """
    Date formatted as YYYY-MM-DD; eg: 2019-08-25.
    This date must be the local date in the timezone where the service occurred.
    If omitted, the Encounter is assumed to be for a single day.
    Must not be temporally before the date_of_service field.
    If service lines have distinct end_date_of_service values, updating the encounter's end_date_of_service will fail. If all service line end_date_of_service values are the same, updating the encounter's end_date_of_service will update all service line date_of_service values.
    """

    additional_information: typing.Optional[str] = pydantic.Field(default=None)
    """
    Defines additional information on the claim needed by the payer.
    Box 19 on the CMS-1500 claim form.
    """

    service_authorization_exception_code: typing.Optional[ServiceAuthorizationExceptionCode] = pydantic.Field(
        default=None
    )
    """
    837p Loop2300 REF*4N
    Required when mandated by government law or regulation to obtain authorization for specific service(s) but, for the
    reasons listed in one of the enum values of ServiceAuthorizationExceptionCode, the service was performed without
    obtaining the authorization.
    """

    admission_date: typing.Optional[dt.date] = pydantic.Field(default=None)
    """
    837p Loop2300 DTP*435, CMS-1500 Box 18
    Required on all ambulance claims when the patient was known to be admitted to the hospital.
    OR
    Required on all claims involving inpatient medical visits.
    """

    discharge_date: typing.Optional[dt.date] = pydantic.Field(default=None)
    """
    837p Loop2300 DTP*096, CMS-1500 Box 18
    Required for inpatient claims when the patient was discharged from the facility and the discharge date is known.
    """

    onset_of_current_illness_or_symptom_date: typing.Optional[dt.date] = pydantic.Field(default=None)
    """
    837p Loop2300 DTP*431, CMS-1500 Box 14
    Required for the initial medical service or visit performed in response to a medical emergency when the date is available and is different than the date of service.
    OR
    This date is the onset of acute symptoms for the current illness or condition.
    """

    last_menstrual_period_date: typing.Optional[dt.date] = pydantic.Field(default=None)
    """
    837p Loop2300 DTP*484, CMS-1500 Box 14
    Required when, in the judgment of the provider, the services on this claim are related to the patient's pregnancy.de
    """

    delay_reason_code: typing.Optional[DelayReasonCode] = pydantic.Field(default=None)
    """
    837i Loop2300, CLM-1300 Box 20
    Code indicating the reason why a request was delayed
    """

    patient_authorized_release: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this patient has authorized the release of medical information
    for billing purpose.
    Box 12 on the CMS-1500 claim form.
    """

    vitals: typing.Optional[VitalsUpdate] = pydantic.Field(default=None)
    """
    If a vitals entity already exists for the encounter, then all values will be updated to the provided values.
    Otherwise, a new vitals object will be created for the encounter.
    """

    referral_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Refers to REF*9F on the 837p. Value cannot be greater than 50 characters.
    """

    secondary_payer_carrier_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    When Medicaid is billed as the secondary payer the Carrier Code is used to identify the primary payer. This is required for certain states.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
