# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .intake_question_id import IntakeQuestionId
from .intake_response_and_follow_ups import IntakeResponseAndFollowUps


class IntakeQuestion(UniversalBaseModel):
    """
    Examples
    --------
    from candid.resources.encounters.resources.v_4 import (
        IntakeFollowUp,
        IntakeQuestion,
        IntakeResponseAndFollowUps,
    )

    IntakeQuestion(
        id="6E7FBCE4-A8EA-46D0-A8D8-FF83CA3BB176",
        text="Do you have any allergies?",
        responses=[
            IntakeResponseAndFollowUps(
                response="No allergies",
                follow_ups=[
                    IntakeFollowUp(
                        id="4F3D57F9-AC94-49D6-87E4-E804B709917A",
                        text="Do you have any allergies?",
                        response="No allergies",
                    )
                ],
            )
        ],
    )
    """

    id: IntakeQuestionId
    text: str
    responses: typing.Optional[typing.List[IntakeResponseAndFollowUps]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
