# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .lab_code_type import LabCodeType


class Lab(UniversalBaseModel):
    """
    Examples
    --------
    from candid.resources.encounters.resources.v_4 import Lab, LabCodeType

    Lab(
        name="Genetic Health Labs",
        code="GH12345",
        code_type=LabCodeType.QUEST,
    )
    """

    name: str
    code: typing.Optional[str] = None
    code_type: typing.Optional[LabCodeType] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
