# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .rx_cui import RxCui


class Medication(UniversalBaseModel):
    """
    Examples
    --------
    from candid.resources.encounters.resources.v_4 import Medication

    Medication(
        name="Lisinopril",
        rx_cui="860975",
        dosage="10mg",
        dosage_form="Tablet",
        frequency="Once Daily",
        as_needed=True,
    )
    """

    name: str
    rx_cui: typing.Optional[RxCui] = None
    dosage: typing.Optional[str] = None
    dosage_form: typing.Optional[str] = None
    frequency: typing.Optional[str] = None
    as_needed: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
