# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class NoteCategory(str, enum.Enum):
    CLINICAL = "clinical"
    CARE_PLAN = "care_plan"
    DIAGNOSES = "diagnoses"
    VITALS = "vitals"
    PHYSICAL_EXAM = "physical_exam"
    REVIEW_OF_SYSTEMS = "review_of_systems"
    MEDICAL_DECISIONS = "medical_decisions"
    HISTORY_OF_PRESENT_ILLNESS = "history_of_present_illness"
    PATIENT_INFO = "patient_info"
    CHIEF_COMPLAINT = "chief_complaint"
    HEALTH_RECORD = "health_record"
    CONSENT = "consent"
    PROCEDURE = "procedure"
    TIME_IN_APPOINTMENT = "time_in_appointment"
    _UNKNOWN = "__NOTECATEGORY_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "NoteCategory":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        clinical: typing.Callable[[], T_Result],
        care_plan: typing.Callable[[], T_Result],
        diagnoses: typing.Callable[[], T_Result],
        vitals: typing.Callable[[], T_Result],
        physical_exam: typing.Callable[[], T_Result],
        review_of_systems: typing.Callable[[], T_Result],
        medical_decisions: typing.Callable[[], T_Result],
        history_of_present_illness: typing.Callable[[], T_Result],
        patient_info: typing.Callable[[], T_Result],
        chief_complaint: typing.Callable[[], T_Result],
        health_record: typing.Callable[[], T_Result],
        consent: typing.Callable[[], T_Result],
        procedure: typing.Callable[[], T_Result],
        time_in_appointment: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is NoteCategory.CLINICAL:
            return clinical()
        if self is NoteCategory.CARE_PLAN:
            return care_plan()
        if self is NoteCategory.DIAGNOSES:
            return diagnoses()
        if self is NoteCategory.VITALS:
            return vitals()
        if self is NoteCategory.PHYSICAL_EXAM:
            return physical_exam()
        if self is NoteCategory.REVIEW_OF_SYSTEMS:
            return review_of_systems()
        if self is NoteCategory.MEDICAL_DECISIONS:
            return medical_decisions()
        if self is NoteCategory.HISTORY_OF_PRESENT_ILLNESS:
            return history_of_present_illness()
        if self is NoteCategory.PATIENT_INFO:
            return patient_info()
        if self is NoteCategory.CHIEF_COMPLAINT:
            return chief_complaint()
        if self is NoteCategory.HEALTH_RECORD:
            return health_record()
        if self is NoteCategory.CONSENT:
            return consent()
        if self is NoteCategory.PROCEDURE:
            return procedure()
        if self is NoteCategory.TIME_IN_APPOINTMENT:
            return time_in_appointment()
        return _unknown_member(self._value_)
