# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ServiceAuthorizationExceptionCode(str, enum.Enum):
    """
    Required when mandated by government law or regulation to obtain authorization for specific service(s) but, for the
    reasons listed in one of the enum values, the service was performed without obtaining the authorization.
    """

    C_1 = "1"
    """
    Immediate/Urgent Care
    """

    C_2 = "2"
    """
    Services Rendered in a Retroactive Period
    """

    C_3 = "3"
    """
    Emergency Care
    """

    C_4 = "4"
    """
    Client has Temporary Medicaid
    """

    C_5 = "5"
    """
    Request from County for Second Opinion to Determine if Recipient Can Work
    """

    C_6 = "6"
    """
    Request for Override Pending
    """

    C_7 = "7"
    """
    Special Handling
    """

    _UNKNOWN = "__SERVICEAUTHORIZATIONEXCEPTIONCODE_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "ServiceAuthorizationExceptionCode":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        c_1: typing.Callable[[], T_Result],
        c_2: typing.Callable[[], T_Result],
        c_3: typing.Callable[[], T_Result],
        c_4: typing.Callable[[], T_Result],
        c_5: typing.Callable[[], T_Result],
        c_6: typing.Callable[[], T_Result],
        c_7: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is ServiceAuthorizationExceptionCode.C_1:
            return c_1()
        if self is ServiceAuthorizationExceptionCode.C_2:
            return c_2()
        if self is ServiceAuthorizationExceptionCode.C_3:
            return c_3()
        if self is ServiceAuthorizationExceptionCode.C_4:
            return c_4()
        if self is ServiceAuthorizationExceptionCode.C_5:
            return c_5()
        if self is ServiceAuthorizationExceptionCode.C_6:
            return c_6()
        if self is ServiceAuthorizationExceptionCode.C_7:
            return c_7()
        return _unknown_member(self._value_)
