# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ....commons.types.date import Date
from ....commons.types.insurance_type_code import InsuranceTypeCode
from ....commons.types.state import State
from .raw_client import AsyncRawV1Client, RawV1Client
from .types.expected_network_status_response import ExpectedNetworkStatusResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV1Client
        """
        return self._raw_client

    def compute(
        self,
        *,
        subscriber_payer_id: str,
        subscriber_payer_name: str,
        billing_provider_npi: str,
        billing_provider_tin: str,
        rendering_provider_npi: str,
        contracted_state: State,
        date_of_service: Date,
        external_patient_id: typing.Optional[str] = OMIT,
        subscriber_insurance_type: typing.Optional[InsuranceTypeCode] = OMIT,
        subscriber_plan_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExpectedNetworkStatusResponse:
        """
        Computes the expected network status given the provided information.

        Parameters
        ----------
        subscriber_payer_id : str

        subscriber_payer_name : str

        billing_provider_npi : str
            The National Provider Identifier (NPI) of the healthcare provider responsible for billing. A unique 10-digit identification number.

        billing_provider_tin : str
            Follow the 9-digit format of the Taxpayer Identification Number (TIN).

        rendering_provider_npi : str
            The National Provider Identifier (NPI) of the healthcare provider who delivered the services. A unique 10-digit identification number.

        contracted_state : State
            The state in which the healthcare provider has a contractual agreement with the insurance payer.

        date_of_service : Date
            Date formatted as YYYY-MM-DD; eg: 2019-08-25.

        external_patient_id : typing.Optional[str]

        subscriber_insurance_type : typing.Optional[InsuranceTypeCode]

        subscriber_plan_name : typing.Optional[str]
            The descriptive name of the insurance plan selected by the subscriber, often indicating coverage specifics or tier.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExpectedNetworkStatusResponse

        Examples
        --------
        from candid import CandidApiClient
        from candid.resources.commons import State

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.expected_network_status.v_1.compute(
            subscriber_payer_id="subscriber_payer_id",
            subscriber_payer_name="subscriber_payer_name",
            billing_provider_npi="billing_provider_npi",
            billing_provider_tin="billing_provider_tin",
            rendering_provider_npi="rendering_provider_npi",
            contracted_state=State.AA,
            date_of_service="date_of_service",
        )
        """
        _response = self._raw_client.compute(
            subscriber_payer_id=subscriber_payer_id,
            subscriber_payer_name=subscriber_payer_name,
            billing_provider_npi=billing_provider_npi,
            billing_provider_tin=billing_provider_tin,
            rendering_provider_npi=rendering_provider_npi,
            contracted_state=contracted_state,
            date_of_service=date_of_service,
            external_patient_id=external_patient_id,
            subscriber_insurance_type=subscriber_insurance_type,
            subscriber_plan_name=subscriber_plan_name,
            request_options=request_options,
        )
        return _response.data


class AsyncV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV1Client
        """
        return self._raw_client

    async def compute(
        self,
        *,
        subscriber_payer_id: str,
        subscriber_payer_name: str,
        billing_provider_npi: str,
        billing_provider_tin: str,
        rendering_provider_npi: str,
        contracted_state: State,
        date_of_service: Date,
        external_patient_id: typing.Optional[str] = OMIT,
        subscriber_insurance_type: typing.Optional[InsuranceTypeCode] = OMIT,
        subscriber_plan_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExpectedNetworkStatusResponse:
        """
        Computes the expected network status given the provided information.

        Parameters
        ----------
        subscriber_payer_id : str

        subscriber_payer_name : str

        billing_provider_npi : str
            The National Provider Identifier (NPI) of the healthcare provider responsible for billing. A unique 10-digit identification number.

        billing_provider_tin : str
            Follow the 9-digit format of the Taxpayer Identification Number (TIN).

        rendering_provider_npi : str
            The National Provider Identifier (NPI) of the healthcare provider who delivered the services. A unique 10-digit identification number.

        contracted_state : State
            The state in which the healthcare provider has a contractual agreement with the insurance payer.

        date_of_service : Date
            Date formatted as YYYY-MM-DD; eg: 2019-08-25.

        external_patient_id : typing.Optional[str]

        subscriber_insurance_type : typing.Optional[InsuranceTypeCode]

        subscriber_plan_name : typing.Optional[str]
            The descriptive name of the insurance plan selected by the subscriber, often indicating coverage specifics or tier.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExpectedNetworkStatusResponse

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient
        from candid.resources.commons import State

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.expected_network_status.v_1.compute(
                subscriber_payer_id="subscriber_payer_id",
                subscriber_payer_name="subscriber_payer_name",
                billing_provider_npi="billing_provider_npi",
                billing_provider_tin="billing_provider_tin",
                rendering_provider_npi="rendering_provider_npi",
                contracted_state=State.AA,
                date_of_service="date_of_service",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.compute(
            subscriber_payer_id=subscriber_payer_id,
            subscriber_payer_name=subscriber_payer_name,
            billing_provider_npi=billing_provider_npi,
            billing_provider_tin=billing_provider_tin,
            rendering_provider_npi=rendering_provider_npi,
            contracted_state=contracted_state,
            date_of_service=date_of_service,
            external_patient_id=external_patient_id,
            subscriber_insurance_type=subscriber_insurance_type,
            subscriber_plan_name=subscriber_plan_name,
            request_options=request_options,
        )
        return _response.data
