# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.pydantic_utilities import parse_obj_as
from .....core.request_options import RequestOptions
from ....commons.types.date import Date
from ....commons.types.insurance_type_code import InsuranceTypeCode
from ....commons.types.state import State
from .types.expected_network_status_response import ExpectedNetworkStatusResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawV1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def compute(
        self,
        *,
        subscriber_payer_id: str,
        subscriber_payer_name: str,
        billing_provider_npi: str,
        billing_provider_tin: str,
        rendering_provider_npi: str,
        contracted_state: State,
        date_of_service: Date,
        external_patient_id: typing.Optional[str] = OMIT,
        subscriber_insurance_type: typing.Optional[InsuranceTypeCode] = OMIT,
        subscriber_plan_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ExpectedNetworkStatusResponse]:
        """
        Computes the expected network status given the provided information.

        Parameters
        ----------
        subscriber_payer_id : str

        subscriber_payer_name : str

        billing_provider_npi : str
            The National Provider Identifier (NPI) of the healthcare provider responsible for billing. A unique 10-digit identification number.

        billing_provider_tin : str
            Follow the 9-digit format of the Taxpayer Identification Number (TIN).

        rendering_provider_npi : str
            The National Provider Identifier (NPI) of the healthcare provider who delivered the services. A unique 10-digit identification number.

        contracted_state : State
            The state in which the healthcare provider has a contractual agreement with the insurance payer.

        date_of_service : Date
            Date formatted as YYYY-MM-DD; eg: 2019-08-25.

        external_patient_id : typing.Optional[str]

        subscriber_insurance_type : typing.Optional[InsuranceTypeCode]

        subscriber_plan_name : typing.Optional[str]
            The descriptive name of the insurance plan selected by the subscriber, often indicating coverage specifics or tier.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ExpectedNetworkStatusResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/expected-network-status/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json={
                "external_patient_id": external_patient_id,
                "subscriber_payer_id": subscriber_payer_id,
                "subscriber_payer_name": subscriber_payer_name,
                "subscriber_insurance_type": subscriber_insurance_type,
                "subscriber_plan_name": subscriber_plan_name,
                "billing_provider_npi": billing_provider_npi,
                "billing_provider_tin": billing_provider_tin,
                "rendering_provider_npi": rendering_provider_npi,
                "contracted_state": contracted_state,
                "date_of_service": date_of_service,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ExpectedNetworkStatusResponse,
                parse_obj_as(
                    type_=ExpectedNetworkStatusResponse,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def compute(
        self,
        *,
        subscriber_payer_id: str,
        subscriber_payer_name: str,
        billing_provider_npi: str,
        billing_provider_tin: str,
        rendering_provider_npi: str,
        contracted_state: State,
        date_of_service: Date,
        external_patient_id: typing.Optional[str] = OMIT,
        subscriber_insurance_type: typing.Optional[InsuranceTypeCode] = OMIT,
        subscriber_plan_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ExpectedNetworkStatusResponse]:
        """
        Computes the expected network status given the provided information.

        Parameters
        ----------
        subscriber_payer_id : str

        subscriber_payer_name : str

        billing_provider_npi : str
            The National Provider Identifier (NPI) of the healthcare provider responsible for billing. A unique 10-digit identification number.

        billing_provider_tin : str
            Follow the 9-digit format of the Taxpayer Identification Number (TIN).

        rendering_provider_npi : str
            The National Provider Identifier (NPI) of the healthcare provider who delivered the services. A unique 10-digit identification number.

        contracted_state : State
            The state in which the healthcare provider has a contractual agreement with the insurance payer.

        date_of_service : Date
            Date formatted as YYYY-MM-DD; eg: 2019-08-25.

        external_patient_id : typing.Optional[str]

        subscriber_insurance_type : typing.Optional[InsuranceTypeCode]

        subscriber_plan_name : typing.Optional[str]
            The descriptive name of the insurance plan selected by the subscriber, often indicating coverage specifics or tier.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ExpectedNetworkStatusResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/expected-network-status/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json={
                "external_patient_id": external_patient_id,
                "subscriber_payer_id": subscriber_payer_id,
                "subscriber_payer_name": subscriber_payer_name,
                "subscriber_insurance_type": subscriber_insurance_type,
                "subscriber_plan_name": subscriber_plan_name,
                "billing_provider_npi": billing_provider_npi,
                "billing_provider_tin": billing_provider_tin,
                "rendering_provider_npi": rendering_provider_npi,
                "contracted_state": contracted_state,
                "date_of_service": date_of_service,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ExpectedNetworkStatusResponse,
                parse_obj_as(
                    type_=ExpectedNetworkStatusResponse,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
