# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ....organization_providers.resources.v_2.types.organization_provider_id import OrganizationProviderId
from .raw_client import AsyncRawV2Client, RawV2Client
from .types.compute_all_in_network_providers_request import ComputeAllInNetworkProvidersRequest
from .types.compute_all_in_network_providers_response import ComputeAllInNetworkProvidersResponse
from .types.expected_network_status_request_v_2 import ExpectedNetworkStatusRequestV2
from .types.expected_network_status_response_v_2 import ExpectedNetworkStatusResponseV2

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V2Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV2Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV2Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV2Client
        """
        return self._raw_client

    def compute_for_rendering_provider(
        self,
        rendering_provider_id: OrganizationProviderId,
        *,
        request: ExpectedNetworkStatusRequestV2,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExpectedNetworkStatusResponseV2:
        """
        Computes the expected network status for a given rendering provider.
        This endpoint is not available to all customers. Reach out to the Candid sales team
        to discuss enabling this endpoint if it is not available for your organization.

        Parameters
        ----------
        rendering_provider_id : OrganizationProviderId

        request : ExpectedNetworkStatusRequestV2

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExpectedNetworkStatusResponseV2

        Examples
        --------
        import datetime
        import uuid

        from candid import CandidApiClient
        from candid.resources.commons import (
            FacilityTypeCode,
            InsuranceTypeCode,
            State,
            StreetAddressShortZip,
        )
        from candid.resources.expected_network_status.resources.v_2 import (
            ExpectedNetworkStatusRequestV2,
            ExpectedNetworkStatusSubscriberInformation,
            InsuranceType,
            InsuranceTypeCodes_InsuranceTypeCode,
            LineOfBusiness,
            ServiceType,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.expected_network_status.v_2.compute_for_rendering_provider(
            rendering_provider_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            request=ExpectedNetworkStatusRequestV2(
                service_type=ServiceType.NEW_PATIENT_VIDEO_APPT,
                place_of_service_code=FacilityTypeCode.PHARMACY,
                subscriber_information=ExpectedNetworkStatusSubscriberInformation(
                    payer_uuid=uuid.UUID(
                        "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                    ),
                    member_id="member_id",
                    insurance_type=InsuranceType(
                        line_of_business=LineOfBusiness.MEDICARE,
                        insurance_type_codes=InsuranceTypeCodes_InsuranceTypeCode(
                            value=InsuranceTypeCode.C_01
                        ),
                    ),
                ),
                patient_address=StreetAddressShortZip(
                    address_1="address1",
                    city="city",
                    state=State.AA,
                    zip_code="zip_code",
                ),
                billing_provider_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                organization_service_facility_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                date_of_service=datetime.date.fromisoformat(
                    "2023-01-15",
                ),
            ),
        )
        """
        _response = self._raw_client.compute_for_rendering_provider(
            rendering_provider_id, request=request, request_options=request_options
        )
        return _response.data

    def compute_all_in_network_providers(
        self, *, request: ComputeAllInNetworkProvidersRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> ComputeAllInNetworkProvidersResponse:
        """
        Computes all the in network providers for a given set of inputs.
        This endpoint is not available to all customers. Reach out to the Candid sales team
        to discuss enabling this endpoint if it is not available for your organization.

        Parameters
        ----------
        request : ComputeAllInNetworkProvidersRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ComputeAllInNetworkProvidersResponse

        Examples
        --------
        import datetime
        import uuid

        from candid import CandidApiClient
        from candid.resources.commons import (
            FacilityTypeCode,
            InsuranceTypeCode,
            State,
            StreetAddressShortZip,
        )
        from candid.resources.expected_network_status.resources.v_2 import (
            ComputeAllInNetworkProvidersRequest,
            ExpectedNetworkStatusSubscriberInformation,
            InsuranceType,
            InsuranceTypeCodes_InsuranceTypeCode,
            LineOfBusiness,
            ServiceType,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.expected_network_status.v_2.compute_all_in_network_providers(
            request=ComputeAllInNetworkProvidersRequest(
                service_type=ServiceType.NEW_PATIENT_VIDEO_APPT,
                place_of_service_code=FacilityTypeCode.PHARMACY,
                subscriber_information=ExpectedNetworkStatusSubscriberInformation(
                    payer_uuid=uuid.UUID(
                        "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                    ),
                    member_id="member_id",
                    insurance_type=InsuranceType(
                        line_of_business=LineOfBusiness.MEDICARE,
                        insurance_type_codes=InsuranceTypeCodes_InsuranceTypeCode(
                            value=InsuranceTypeCode.C_01
                        ),
                    ),
                ),
                patient_address=StreetAddressShortZip(
                    address_1="address1",
                    city="city",
                    state=State.AA,
                    zip_code="zip_code",
                ),
                billing_provider_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                organization_service_facility_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                date_of_service=datetime.date.fromisoformat(
                    "2023-01-15",
                ),
            ),
        )
        """
        _response = self._raw_client.compute_all_in_network_providers(request=request, request_options=request_options)
        return _response.data


class AsyncV2Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV2Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV2Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV2Client
        """
        return self._raw_client

    async def compute_for_rendering_provider(
        self,
        rendering_provider_id: OrganizationProviderId,
        *,
        request: ExpectedNetworkStatusRequestV2,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExpectedNetworkStatusResponseV2:
        """
        Computes the expected network status for a given rendering provider.
        This endpoint is not available to all customers. Reach out to the Candid sales team
        to discuss enabling this endpoint if it is not available for your organization.

        Parameters
        ----------
        rendering_provider_id : OrganizationProviderId

        request : ExpectedNetworkStatusRequestV2

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExpectedNetworkStatusResponseV2

        Examples
        --------
        import asyncio
        import datetime
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.commons import (
            FacilityTypeCode,
            InsuranceTypeCode,
            State,
            StreetAddressShortZip,
        )
        from candid.resources.expected_network_status.resources.v_2 import (
            ExpectedNetworkStatusRequestV2,
            ExpectedNetworkStatusSubscriberInformation,
            InsuranceType,
            InsuranceTypeCodes_InsuranceTypeCode,
            LineOfBusiness,
            ServiceType,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.expected_network_status.v_2.compute_for_rendering_provider(
                rendering_provider_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                request=ExpectedNetworkStatusRequestV2(
                    service_type=ServiceType.NEW_PATIENT_VIDEO_APPT,
                    place_of_service_code=FacilityTypeCode.PHARMACY,
                    subscriber_information=ExpectedNetworkStatusSubscriberInformation(
                        payer_uuid=uuid.UUID(
                            "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                        ),
                        member_id="member_id",
                        insurance_type=InsuranceType(
                            line_of_business=LineOfBusiness.MEDICARE,
                            insurance_type_codes=InsuranceTypeCodes_InsuranceTypeCode(
                                value=InsuranceTypeCode.C_01
                            ),
                        ),
                    ),
                    patient_address=StreetAddressShortZip(
                        address_1="address1",
                        city="city",
                        state=State.AA,
                        zip_code="zip_code",
                    ),
                    billing_provider_id=uuid.UUID(
                        "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                    ),
                    organization_service_facility_id=uuid.UUID(
                        "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                    ),
                    date_of_service=datetime.date.fromisoformat(
                        "2023-01-15",
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.compute_for_rendering_provider(
            rendering_provider_id, request=request, request_options=request_options
        )
        return _response.data

    async def compute_all_in_network_providers(
        self, *, request: ComputeAllInNetworkProvidersRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> ComputeAllInNetworkProvidersResponse:
        """
        Computes all the in network providers for a given set of inputs.
        This endpoint is not available to all customers. Reach out to the Candid sales team
        to discuss enabling this endpoint if it is not available for your organization.

        Parameters
        ----------
        request : ComputeAllInNetworkProvidersRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ComputeAllInNetworkProvidersResponse

        Examples
        --------
        import asyncio
        import datetime
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.commons import (
            FacilityTypeCode,
            InsuranceTypeCode,
            State,
            StreetAddressShortZip,
        )
        from candid.resources.expected_network_status.resources.v_2 import (
            ComputeAllInNetworkProvidersRequest,
            ExpectedNetworkStatusSubscriberInformation,
            InsuranceType,
            InsuranceTypeCodes_InsuranceTypeCode,
            LineOfBusiness,
            ServiceType,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.expected_network_status.v_2.compute_all_in_network_providers(
                request=ComputeAllInNetworkProvidersRequest(
                    service_type=ServiceType.NEW_PATIENT_VIDEO_APPT,
                    place_of_service_code=FacilityTypeCode.PHARMACY,
                    subscriber_information=ExpectedNetworkStatusSubscriberInformation(
                        payer_uuid=uuid.UUID(
                            "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                        ),
                        member_id="member_id",
                        insurance_type=InsuranceType(
                            line_of_business=LineOfBusiness.MEDICARE,
                            insurance_type_codes=InsuranceTypeCodes_InsuranceTypeCode(
                                value=InsuranceTypeCode.C_01
                            ),
                        ),
                    ),
                    patient_address=StreetAddressShortZip(
                        address_1="address1",
                        city="city",
                        state=State.AA,
                        zip_code="zip_code",
                    ),
                    billing_provider_id=uuid.UUID(
                        "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                    ),
                    organization_service_facility_id=uuid.UUID(
                        "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                    ),
                    date_of_service=datetime.date.fromisoformat(
                        "2023-01-15",
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.compute_all_in_network_providers(
            request=request, request_options=request_options
        )
        return _response.data
