# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....commons.types.facility_type_code import FacilityTypeCode
from .....commons.types.street_address_short_zip import StreetAddressShortZip
from .....organization_providers.resources.v_2.types.organization_provider_id import OrganizationProviderId
from .....organization_service_facilities.resources.v_2.types.organization_service_facility_id import (
    OrganizationServiceFacilityId,
)
from .expected_network_status_subscriber_information import ExpectedNetworkStatusSubscriberInformation
from .service_type import ServiceType


class ExpectedNetworkStatusRequestV2(UniversalBaseModel):
    service_type: ServiceType = pydantic.Field()
    """
    For some payers, payer routing depends on whether the rendered service qualifies as a behavioral health visit
    (e.g. Blue Shield of California routes to Magellan for behavioral health visits).
    
    For post appointment payer routing, Candid uses a CPT code list to determine whether the appointment qualifies as a
    behavioral health visit
    (see “Inputs: Service Type” in the appendix for list of qualifying CPT codes and behavioral health routing logic).
    Since CPT codes are not available pre-appointment, the service type input is used to determine whether the appointment is expected
    to qualify as behavioral health.
    """

    place_of_service_code: FacilityTypeCode = pydantic.Field()
    """
    Expected place of service
    """

    subscriber_information: ExpectedNetworkStatusSubscriberInformation = pydantic.Field()
    """
    Information present on the patient's insurance card
    """

    patient_address: StreetAddressShortZip
    billing_provider_id: OrganizationProviderId
    organization_service_facility_id: OrganizationServiceFacilityId = pydantic.Field()
    """
    The id of the service facility where the appointment will be rendered
    """

    date_of_service: dt.date = pydantic.Field()
    """
    Expected date of service
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
