# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class Explanation(str, enum.Enum):
    ROUTING_FAILED = "Payer Routing and/or Billing Provider Routing Failed"
    PAYER_MATCH_FAILED = "No Effective Contract with Payer"
    BILLING_PROVIDER_MATCH_FAILED = "No Effective Contract with Billing Provider"
    COVERED_GEOGRAPHY_MATCH_FAILED = "No Effective Contract with Covered Geography"
    LINE_OF_BUSINESS_MATCH_FAILED = "No Effective Contract with Line of Business"
    INSURANCE_TYPE_MATCH_FAILED = "No Effective Contract with Insurance Type"
    RENDERING_PROVIDER_MATCH_FAILED = "No Effective Contract with Rendering Provider"
    RENDERING_PROVIDER_CREDENTIALING_CHECK_FAILED = "Rendering Provider Not Credentialed"
    _UNKNOWN = "__EXPLANATION_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "Explanation":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        routing_failed: typing.Callable[[], T_Result],
        payer_match_failed: typing.Callable[[], T_Result],
        billing_provider_match_failed: typing.Callable[[], T_Result],
        covered_geography_match_failed: typing.Callable[[], T_Result],
        line_of_business_match_failed: typing.Callable[[], T_Result],
        insurance_type_match_failed: typing.Callable[[], T_Result],
        rendering_provider_match_failed: typing.Callable[[], T_Result],
        rendering_provider_credentialing_check_failed: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is Explanation.ROUTING_FAILED:
            return routing_failed()
        if self is Explanation.PAYER_MATCH_FAILED:
            return payer_match_failed()
        if self is Explanation.BILLING_PROVIDER_MATCH_FAILED:
            return billing_provider_match_failed()
        if self is Explanation.COVERED_GEOGRAPHY_MATCH_FAILED:
            return covered_geography_match_failed()
        if self is Explanation.LINE_OF_BUSINESS_MATCH_FAILED:
            return line_of_business_match_failed()
        if self is Explanation.INSURANCE_TYPE_MATCH_FAILED:
            return insurance_type_match_failed()
        if self is Explanation.RENDERING_PROVIDER_MATCH_FAILED:
            return rendering_provider_match_failed()
        if self is Explanation.RENDERING_PROVIDER_CREDENTIALING_CHECK_FAILED:
            return rendering_provider_credentialing_check_failed()
        return _unknown_member(self._value_)
