# This file was auto-generated by Fern from our API Definition.

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawExportsClient, RawExportsClient
from .resources.v_3.client import AsyncV3Client, V3Client


class ExportsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawExportsClient(client_wrapper=client_wrapper)
        self.v_3 = V3Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawExportsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawExportsClient
        """
        return self._raw_client


class AsyncExportsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawExportsClient(client_wrapper=client_wrapper)
        self.v_3 = AsyncV3Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawExportsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawExportsClient
        """
        return self._raw_client
