# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from .raw_client import AsyncRawV3Client, RawV3Client
from .types.get_exports_response import GetExportsResponse


class V3Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV3Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV3Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV3Client
        """
        return self._raw_client

    def get_exports(
        self, *, start_date: dt.date, end_date: dt.date, request_options: typing.Optional[RequestOptions] = None
    ) -> GetExportsResponse:
        """
        Retrieve CSV-formatted reports on claim submissions and outcomes. This endpoint returns Export objects that contain an
        authenticated URL to a customer's reports with a 2min TTL. The schema for the CSV export can be found [here](https://app.joincandidhealth.com/files/exports_schema.csv).

        **Schema changes:** Changing column order, removing columns, or changing the name of a column is considered a
        [Breaking Change](../../../api-principles/breaking-changes). Adding new columns to the end of the Exports file is not considered a
        Breaking Change and happens periodically. For this reason, it is important that any downstream automation or processes built on top
        of Candid Health's export files be resilient to the addition of new columns at the end of the file.

        **SLA guarantees:** Files for a given date are guaranteed to be available after 3 business days. For example, Friday's file will be
        available by Wednesday at the latest. If file generation is still in progress upon request before 3 business days have passed, the
        caller will receive a 422 response. If the file has already been generated, it will be served. Historic files should be available
        up to 90 days in the past by default. Please email our [Support team](mailto:support@joincandidhealth.com) with any data requests
        outside of these stated guarantees.

        **New Customers:** This endpoint is not enabled by default for new Candid customers. To have this endpoint enabled for your organization,
        please email our [Support team](mailto:support@joincandidhealth.com) with the request.

        Parameters
        ----------
        start_date : dt.date
            Beginning date of claim versions returned in the export, ISO 8601 date e.g. 2019-08-24.
            Must be at least 1 calendar day in the past. Cannot be earlier than 2022-10-07.

        end_date : dt.date
            Ending date of claim versions returned in the export, ISO 8601 date; e.g. 2019-08-24.
            Must be within 30 days of start_date.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetExportsResponse

        Examples
        --------
        import datetime

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.exports.v_3.get_exports(
            start_date=datetime.date.fromisoformat(
                "2023-10-01",
            ),
            end_date=datetime.date.fromisoformat(
                "2023-10-02",
            ),
        )
        """
        _response = self._raw_client.get_exports(
            start_date=start_date, end_date=end_date, request_options=request_options
        )
        return _response.data


class AsyncV3Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV3Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV3Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV3Client
        """
        return self._raw_client

    async def get_exports(
        self, *, start_date: dt.date, end_date: dt.date, request_options: typing.Optional[RequestOptions] = None
    ) -> GetExportsResponse:
        """
        Retrieve CSV-formatted reports on claim submissions and outcomes. This endpoint returns Export objects that contain an
        authenticated URL to a customer's reports with a 2min TTL. The schema for the CSV export can be found [here](https://app.joincandidhealth.com/files/exports_schema.csv).

        **Schema changes:** Changing column order, removing columns, or changing the name of a column is considered a
        [Breaking Change](../../../api-principles/breaking-changes). Adding new columns to the end of the Exports file is not considered a
        Breaking Change and happens periodically. For this reason, it is important that any downstream automation or processes built on top
        of Candid Health's export files be resilient to the addition of new columns at the end of the file.

        **SLA guarantees:** Files for a given date are guaranteed to be available after 3 business days. For example, Friday's file will be
        available by Wednesday at the latest. If file generation is still in progress upon request before 3 business days have passed, the
        caller will receive a 422 response. If the file has already been generated, it will be served. Historic files should be available
        up to 90 days in the past by default. Please email our [Support team](mailto:support@joincandidhealth.com) with any data requests
        outside of these stated guarantees.

        **New Customers:** This endpoint is not enabled by default for new Candid customers. To have this endpoint enabled for your organization,
        please email our [Support team](mailto:support@joincandidhealth.com) with the request.

        Parameters
        ----------
        start_date : dt.date
            Beginning date of claim versions returned in the export, ISO 8601 date e.g. 2019-08-24.
            Must be at least 1 calendar day in the past. Cannot be earlier than 2022-10-07.

        end_date : dt.date
            Ending date of claim versions returned in the export, ISO 8601 date; e.g. 2019-08-24.
            Must be within 30 days of start_date.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetExportsResponse

        Examples
        --------
        import asyncio
        import datetime

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.exports.v_3.get_exports(
                start_date=datetime.date.fromisoformat(
                    "2023-10-01",
                ),
                end_date=datetime.date.fromisoformat(
                    "2023-10-02",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_exports(
            start_date=start_date, end_date=end_date, request_options=request_options
        )
        return _response.data
