# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.pydantic_utilities import parse_obj_as
from .....core.request_options import RequestOptions
from ....commons.errors.http_request_validations_error import HttpRequestValidationsError
from ....commons.types.error_message import ErrorMessage
from ....commons.types.request_validation_error import RequestValidationError
from .errors.export_date_too_early_error import ExportDateTooEarlyError
from .errors.export_files_unavailable_error import ExportFilesUnavailableError
from .errors.export_not_yet_available_error import ExportNotYetAvailableError
from .errors.missing_daily_incremental_export_file_error import MissingDailyIncrementalExportFileError
from .types.get_exports_response import GetExportsResponse


class RawV3Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_exports(
        self, *, start_date: dt.date, end_date: dt.date, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetExportsResponse]:
        """
        Retrieve CSV-formatted reports on claim submissions and outcomes. This endpoint returns Export objects that contain an
        authenticated URL to a customer's reports with a 2min TTL. The schema for the CSV export can be found [here](https://app.joincandidhealth.com/files/exports_schema.csv).

        **Schema changes:** Changing column order, removing columns, or changing the name of a column is considered a
        [Breaking Change](../../../api-principles/breaking-changes). Adding new columns to the end of the Exports file is not considered a
        Breaking Change and happens periodically. For this reason, it is important that any downstream automation or processes built on top
        of Candid Health's export files be resilient to the addition of new columns at the end of the file.

        **SLA guarantees:** Files for a given date are guaranteed to be available after 3 business days. For example, Friday's file will be
        available by Wednesday at the latest. If file generation is still in progress upon request before 3 business days have passed, the
        caller will receive a 422 response. If the file has already been generated, it will be served. Historic files should be available
        up to 90 days in the past by default. Please email our [Support team](mailto:support@joincandidhealth.com) with any data requests
        outside of these stated guarantees.

        **New Customers:** This endpoint is not enabled by default for new Candid customers. To have this endpoint enabled for your organization,
        please email our [Support team](mailto:support@joincandidhealth.com) with the request.

        Parameters
        ----------
        start_date : dt.date
            Beginning date of claim versions returned in the export, ISO 8601 date e.g. 2019-08-24.
            Must be at least 1 calendar day in the past. Cannot be earlier than 2022-10-07.

        end_date : dt.date
            Ending date of claim versions returned in the export, ISO 8601 date; e.g. 2019-08-24.
            Must be within 30 days of start_date.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetExportsResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/exports/v3",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "start_date": str(start_date),
                "end_date": str(end_date),
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                GetExportsResponse,
                parse_obj_as(
                    type_=GetExportsResponse,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "ExportFilesUnavailableError":
                raise ExportFilesUnavailableError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "MissingDailyIncrementalExportFileError":
                raise MissingDailyIncrementalExportFileError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "ExportNotYetAvailableError":
                raise ExportNotYetAvailableError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "ExportDateTooEarlyError":
                raise ExportDateTooEarlyError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawV3Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_exports(
        self, *, start_date: dt.date, end_date: dt.date, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetExportsResponse]:
        """
        Retrieve CSV-formatted reports on claim submissions and outcomes. This endpoint returns Export objects that contain an
        authenticated URL to a customer's reports with a 2min TTL. The schema for the CSV export can be found [here](https://app.joincandidhealth.com/files/exports_schema.csv).

        **Schema changes:** Changing column order, removing columns, or changing the name of a column is considered a
        [Breaking Change](../../../api-principles/breaking-changes). Adding new columns to the end of the Exports file is not considered a
        Breaking Change and happens periodically. For this reason, it is important that any downstream automation or processes built on top
        of Candid Health's export files be resilient to the addition of new columns at the end of the file.

        **SLA guarantees:** Files for a given date are guaranteed to be available after 3 business days. For example, Friday's file will be
        available by Wednesday at the latest. If file generation is still in progress upon request before 3 business days have passed, the
        caller will receive a 422 response. If the file has already been generated, it will be served. Historic files should be available
        up to 90 days in the past by default. Please email our [Support team](mailto:support@joincandidhealth.com) with any data requests
        outside of these stated guarantees.

        **New Customers:** This endpoint is not enabled by default for new Candid customers. To have this endpoint enabled for your organization,
        please email our [Support team](mailto:support@joincandidhealth.com) with the request.

        Parameters
        ----------
        start_date : dt.date
            Beginning date of claim versions returned in the export, ISO 8601 date e.g. 2019-08-24.
            Must be at least 1 calendar day in the past. Cannot be earlier than 2022-10-07.

        end_date : dt.date
            Ending date of claim versions returned in the export, ISO 8601 date; e.g. 2019-08-24.
            Must be within 30 days of start_date.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetExportsResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/exports/v3",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "start_date": str(start_date),
                "end_date": str(end_date),
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                GetExportsResponse,
                parse_obj_as(
                    type_=GetExportsResponse,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "ExportFilesUnavailableError":
                raise ExportFilesUnavailableError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "MissingDailyIncrementalExportFileError":
                raise MissingDailyIncrementalExportFileError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "ExportNotYetAvailableError":
                raise ExportNotYetAvailableError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "ExportDateTooEarlyError":
                raise ExportDateTooEarlyError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
