# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.pydantic_utilities import parse_obj_as
from .....core.request_options import RequestOptions
from ....commons.types.page_token import PageToken
from .types.external_payment_account_config_page import ExternalPaymentAccountConfigPage


class RawV1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ExternalPaymentAccountConfigPage]:
        """
        Parameters
        ----------
        limit : typing.Optional[int]
            Defaults to 100

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ExternalPaymentAccountConfigPage]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/external-payment-account-config/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "limit": limit,
                "page_token": page_token,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ExternalPaymentAccountConfigPage,
                parse_obj_as(
                    type_=ExternalPaymentAccountConfigPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ExternalPaymentAccountConfigPage]:
        """
        Parameters
        ----------
        limit : typing.Optional[int]
            Defaults to 100

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ExternalPaymentAccountConfigPage]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/external-payment-account-config/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "limit": limit,
                "page_token": page_token,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ExternalPaymentAccountConfigPage,
                parse_obj_as(
                    type_=ExternalPaymentAccountConfigPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
