# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.jsonable_encoder import jsonable_encoder
from .....core.pydantic_utilities import parse_obj_as
from .....core.request_options import RequestOptions
from ....commons.errors.entity_conflict_error import EntityConflictError
from ....commons.errors.entity_not_found_error import EntityNotFoundError
from ....commons.types.entity_conflict_error_message import EntityConflictErrorMessage
from ....commons.types.entity_not_found_error_message import EntityNotFoundErrorMessage
from ....commons.types.error_message import ErrorMessage
from ....commons.types.facility_type_code import FacilityTypeCode
from ....commons.types.network_type import NetworkType
from ....commons.types.page_token import PageToken
from ....commons.types.payer_plan_group_id import PayerPlanGroupId
from ....commons.types.procedure_modifier import ProcedureModifier
from ....commons.types.rate_id import RateId
from ....commons.types.service_line_id import ServiceLineId
from ....commons.types.state import State
from ....organization_providers.resources.v_2.types.license_type import LicenseType
from ....organization_providers.resources.v_2.types.organization_provider_id import OrganizationProviderId
from ....payers.resources.v_3.types.payer_uuid import PayerUuid
from .errors.failed_to_build_service_line_dimensions import FailedToBuildServiceLineDimensions
from .errors.fee_schedule_validation_http_error import FeeScheduleValidationHttpError
from .types.dimension_name import DimensionName
from .types.dimensions_page import DimensionsPage
from .types.match_result import MatchResult
from .types.match_test_result import MatchTestResult
from .types.payer_threshold import PayerThreshold
from .types.payer_thresholds_page import PayerThresholdsPage
from .types.rate import Rate
from .types.rate_upload import RateUpload
from .types.rate_upload_with_possible_errors import RateUploadWithPossibleErrors
from .types.rates_page import RatesPage

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawV3Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_match(
        self, service_line_id: ServiceLineId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.Optional[MatchResult]]:
        """
        Gets the rate that matches a service line.  No result means no rate exists matching the service line's dimensions.

        Parameters
        ----------
        service_line_id : ServiceLineId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[MatchResult]]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/fee-schedules/v3/service-line/{jsonable_encoder(service_line_id)}/match",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                typing.Optional[MatchResult],
                parse_obj_as(
                    type_=typing.Optional[MatchResult],  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "FailedToBuildServiceLineDimensions":
                raise FailedToBuildServiceLineDimensions(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def test_match(
        self,
        service_line_id: ServiceLineId,
        rate_id: RateId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[MatchTestResult]:
        """
        Tests a service line against a rate to see if it matches.

        Parameters
        ----------
        service_line_id : ServiceLineId

        rate_id : RateId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[MatchTestResult]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/fee-schedules/v3/service-line/{jsonable_encoder(service_line_id)}/match/{jsonable_encoder(rate_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                MatchTestResult,
                parse_obj_as(
                    type_=MatchTestResult,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "FailedToBuildServiceLineDimensions":
                raise FailedToBuildServiceLineDimensions(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_multi(
        self,
        *,
        page_token: typing.Optional[PageToken] = None,
        limit: typing.Optional[int] = None,
        active_date: typing.Optional[dt.date] = None,
        payer_uuid: typing.Optional[PayerUuid] = None,
        organization_billing_provider_id: typing.Optional[OrganizationProviderId] = None,
        states: typing.Optional[typing.Union[State, typing.Sequence[State]]] = None,
        zip_codes: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        license_types: typing.Optional[typing.Union[LicenseType, typing.Sequence[LicenseType]]] = None,
        facility_type_codes: typing.Optional[typing.Union[FacilityTypeCode, typing.Sequence[FacilityTypeCode]]] = None,
        network_types: typing.Optional[typing.Union[NetworkType, typing.Sequence[NetworkType]]] = None,
        payer_plan_group_ids: typing.Optional[typing.Union[PayerPlanGroupId, typing.Sequence[PayerPlanGroupId]]] = None,
        cpt_code: typing.Optional[str] = None,
        modifiers: typing.Optional[typing.Union[ProcedureModifier, typing.Sequence[ProcedureModifier]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[RatesPage]:
        """
        Gets a list of dimensions with their rates. The rates returned will always be the most recent versions of those rates.

        Parameters
        ----------
        page_token : typing.Optional[PageToken]

        limit : typing.Optional[int]
            Max number of dimensions returned. Defaults to 100. Max is 100.

        active_date : typing.Optional[dt.date]

        payer_uuid : typing.Optional[PayerUuid]

        organization_billing_provider_id : typing.Optional[OrganizationProviderId]

        states : typing.Optional[typing.Union[State, typing.Sequence[State]]]

        zip_codes : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        license_types : typing.Optional[typing.Union[LicenseType, typing.Sequence[LicenseType]]]

        facility_type_codes : typing.Optional[typing.Union[FacilityTypeCode, typing.Sequence[FacilityTypeCode]]]

        network_types : typing.Optional[typing.Union[NetworkType, typing.Sequence[NetworkType]]]

        payer_plan_group_ids : typing.Optional[typing.Union[PayerPlanGroupId, typing.Sequence[PayerPlanGroupId]]]

        cpt_code : typing.Optional[str]

        modifiers : typing.Optional[typing.Union[ProcedureModifier, typing.Sequence[ProcedureModifier]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[RatesPage]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/fee-schedules/v3",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "page_token": page_token,
                "limit": limit,
                "active_date": str(active_date) if active_date is not None else None,
                "payer_uuid": payer_uuid,
                "organization_billing_provider_id": organization_billing_provider_id,
                "states": states,
                "zip_codes": zip_codes,
                "license_types": license_types,
                "facility_type_codes": facility_type_codes,
                "network_types": network_types,
                "payer_plan_group_ids": payer_plan_group_ids,
                "cpt_code": cpt_code,
                "modifiers": modifiers,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                RatesPage,
                parse_obj_as(
                    type_=RatesPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_unique_values_for_dimension(
        self,
        *,
        pivot_dimension: DimensionName,
        page_token: typing.Optional[PageToken] = None,
        limit: typing.Optional[int] = None,
        payer_uuid: typing.Optional[PayerUuid] = None,
        organization_billing_provider_id: typing.Optional[OrganizationProviderId] = None,
        states: typing.Optional[typing.Union[State, typing.Sequence[State]]] = None,
        zip_codes: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        license_types: typing.Optional[typing.Union[LicenseType, typing.Sequence[LicenseType]]] = None,
        facility_type_codes: typing.Optional[typing.Union[FacilityTypeCode, typing.Sequence[FacilityTypeCode]]] = None,
        network_types: typing.Optional[typing.Union[NetworkType, typing.Sequence[NetworkType]]] = None,
        payer_plan_group_ids: typing.Optional[typing.Union[PayerPlanGroupId, typing.Sequence[PayerPlanGroupId]]] = None,
        cpt_code: typing.Optional[str] = None,
        modifiers: typing.Optional[typing.Union[ProcedureModifier, typing.Sequence[ProcedureModifier]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DimensionsPage]:
        """
        Gets unique values for a dimension based on other selection criteria. The response is a list of dimensions with your criteria and the unique values populated. This API is useful for driving pivots on dimension values.

        Parameters
        ----------
        pivot_dimension : DimensionName
            The name of the dimension to fetch unique values for.

        page_token : typing.Optional[PageToken]

        limit : typing.Optional[int]
            Max number of values returned. Defaults to 1000. Max is 1000.

        payer_uuid : typing.Optional[PayerUuid]

        organization_billing_provider_id : typing.Optional[OrganizationProviderId]

        states : typing.Optional[typing.Union[State, typing.Sequence[State]]]

        zip_codes : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        license_types : typing.Optional[typing.Union[LicenseType, typing.Sequence[LicenseType]]]

        facility_type_codes : typing.Optional[typing.Union[FacilityTypeCode, typing.Sequence[FacilityTypeCode]]]

        network_types : typing.Optional[typing.Union[NetworkType, typing.Sequence[NetworkType]]]

        payer_plan_group_ids : typing.Optional[typing.Union[PayerPlanGroupId, typing.Sequence[PayerPlanGroupId]]]

        cpt_code : typing.Optional[str]

        modifiers : typing.Optional[typing.Union[ProcedureModifier, typing.Sequence[ProcedureModifier]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DimensionsPage]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/fee-schedules/v3/unique-dimension-values",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "page_token": page_token,
                "limit": limit,
                "pivot_dimension": pivot_dimension,
                "payer_uuid": payer_uuid,
                "organization_billing_provider_id": organization_billing_provider_id,
                "states": states,
                "zip_codes": zip_codes,
                "license_types": license_types,
                "facility_type_codes": facility_type_codes,
                "network_types": network_types,
                "payer_plan_group_ids": payer_plan_group_ids,
                "cpt_code": cpt_code,
                "modifiers": modifiers,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                DimensionsPage,
                parse_obj_as(
                    type_=DimensionsPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_rate_history(
        self, rate_id: RateId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[Rate]]:
        """
        Gets every version of a rate.

        Parameters
        ----------
        rate_id : RateId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[Rate]]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/fee-schedules/v3/{jsonable_encoder(rate_id)}/history",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                typing.List[Rate],
                parse_obj_as(
                    type_=typing.List[Rate],  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def upload_fee_schedule(
        self,
        *,
        dry_run: bool,
        rates: typing.Sequence[RateUpload],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[Rate]]:
        """
        Uploads a new fee schedule.\n Each rate may either be totally new as qualified by it's dimensions or a new version for an existing rate.\n If adding a new version to an existing rate, the rate must be posted with the next version number (previous version + 1) or a EntityConflictError will be returned.\n Use the dry run flag to discover already existing rates and to run validations.  If validations for any rate fail, no rates will be saved to the system.

        Parameters
        ----------
        dry_run : bool

        rates : typing.Sequence[RateUpload]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[Rate]]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/fee-schedules/v3",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json={
                "dry_run": dry_run,
                "rates": rates,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                typing.List[Rate],
                parse_obj_as(
                    type_=typing.List[Rate],  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "FeeScheduleValidationHttpError":
                raise FeeScheduleValidationHttpError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RateUploadWithPossibleErrors],
                        parse_obj_as(
                            type_=typing.List[RateUploadWithPossibleErrors],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_rate(
        self, rate_id: RateId, version: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Soft deletes a rate from the system.  Only the most recent version of a rate can be deleted.

        Parameters
        ----------
        rate_id : RateId

        version : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/fee-schedules/v3/{jsonable_encoder(rate_id)}/{jsonable_encoder(version)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="DELETE",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return HttpResponse(response=_response, data=None)
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityConflictError":
                raise EntityConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityConflictErrorMessage,
                        parse_obj_as(
                            type_=EntityConflictErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_payer_thresholds_default(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PayerThreshold]:
        """
        Gets the default payer threshold

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PayerThreshold]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/fee-schedules/v3/payer-threshold/default",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                PayerThreshold,
                parse_obj_as(
                    type_=PayerThreshold,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_payer_thresholds(
        self,
        *,
        payer_uuids: typing.Union[PayerUuid, typing.Sequence[PayerUuid]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PayerThresholdsPage]:
        """
        Gets a list of payers and thresholds by their uuids

        Parameters
        ----------
        payer_uuids : typing.Union[PayerUuid, typing.Sequence[PayerUuid]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PayerThresholdsPage]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/fee-schedules/v3/payer-threshold",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "payer_uuids": payer_uuids,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                PayerThresholdsPage,
                parse_obj_as(
                    type_=PayerThresholdsPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def set_payer_threshold(
        self, payer_uuid: PayerUuid, *, request: PayerThreshold, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PayerThreshold]:
        """
        Sets the threshold information for a payer

        Parameters
        ----------
        payer_uuid : PayerUuid

        request : PayerThreshold

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PayerThreshold]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/fee-schedules/v3/payer-threshold/{jsonable_encoder(payer_uuid)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PUT",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                PayerThreshold,
                parse_obj_as(
                    type_=PayerThreshold,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawV3Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_match(
        self, service_line_id: ServiceLineId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.Optional[MatchResult]]:
        """
        Gets the rate that matches a service line.  No result means no rate exists matching the service line's dimensions.

        Parameters
        ----------
        service_line_id : ServiceLineId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[MatchResult]]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/fee-schedules/v3/service-line/{jsonable_encoder(service_line_id)}/match",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                typing.Optional[MatchResult],
                parse_obj_as(
                    type_=typing.Optional[MatchResult],  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "FailedToBuildServiceLineDimensions":
                raise FailedToBuildServiceLineDimensions(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def test_match(
        self,
        service_line_id: ServiceLineId,
        rate_id: RateId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[MatchTestResult]:
        """
        Tests a service line against a rate to see if it matches.

        Parameters
        ----------
        service_line_id : ServiceLineId

        rate_id : RateId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[MatchTestResult]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/fee-schedules/v3/service-line/{jsonable_encoder(service_line_id)}/match/{jsonable_encoder(rate_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                MatchTestResult,
                parse_obj_as(
                    type_=MatchTestResult,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "FailedToBuildServiceLineDimensions":
                raise FailedToBuildServiceLineDimensions(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_multi(
        self,
        *,
        page_token: typing.Optional[PageToken] = None,
        limit: typing.Optional[int] = None,
        active_date: typing.Optional[dt.date] = None,
        payer_uuid: typing.Optional[PayerUuid] = None,
        organization_billing_provider_id: typing.Optional[OrganizationProviderId] = None,
        states: typing.Optional[typing.Union[State, typing.Sequence[State]]] = None,
        zip_codes: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        license_types: typing.Optional[typing.Union[LicenseType, typing.Sequence[LicenseType]]] = None,
        facility_type_codes: typing.Optional[typing.Union[FacilityTypeCode, typing.Sequence[FacilityTypeCode]]] = None,
        network_types: typing.Optional[typing.Union[NetworkType, typing.Sequence[NetworkType]]] = None,
        payer_plan_group_ids: typing.Optional[typing.Union[PayerPlanGroupId, typing.Sequence[PayerPlanGroupId]]] = None,
        cpt_code: typing.Optional[str] = None,
        modifiers: typing.Optional[typing.Union[ProcedureModifier, typing.Sequence[ProcedureModifier]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[RatesPage]:
        """
        Gets a list of dimensions with their rates. The rates returned will always be the most recent versions of those rates.

        Parameters
        ----------
        page_token : typing.Optional[PageToken]

        limit : typing.Optional[int]
            Max number of dimensions returned. Defaults to 100. Max is 100.

        active_date : typing.Optional[dt.date]

        payer_uuid : typing.Optional[PayerUuid]

        organization_billing_provider_id : typing.Optional[OrganizationProviderId]

        states : typing.Optional[typing.Union[State, typing.Sequence[State]]]

        zip_codes : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        license_types : typing.Optional[typing.Union[LicenseType, typing.Sequence[LicenseType]]]

        facility_type_codes : typing.Optional[typing.Union[FacilityTypeCode, typing.Sequence[FacilityTypeCode]]]

        network_types : typing.Optional[typing.Union[NetworkType, typing.Sequence[NetworkType]]]

        payer_plan_group_ids : typing.Optional[typing.Union[PayerPlanGroupId, typing.Sequence[PayerPlanGroupId]]]

        cpt_code : typing.Optional[str]

        modifiers : typing.Optional[typing.Union[ProcedureModifier, typing.Sequence[ProcedureModifier]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[RatesPage]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/fee-schedules/v3",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "page_token": page_token,
                "limit": limit,
                "active_date": str(active_date) if active_date is not None else None,
                "payer_uuid": payer_uuid,
                "organization_billing_provider_id": organization_billing_provider_id,
                "states": states,
                "zip_codes": zip_codes,
                "license_types": license_types,
                "facility_type_codes": facility_type_codes,
                "network_types": network_types,
                "payer_plan_group_ids": payer_plan_group_ids,
                "cpt_code": cpt_code,
                "modifiers": modifiers,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                RatesPage,
                parse_obj_as(
                    type_=RatesPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_unique_values_for_dimension(
        self,
        *,
        pivot_dimension: DimensionName,
        page_token: typing.Optional[PageToken] = None,
        limit: typing.Optional[int] = None,
        payer_uuid: typing.Optional[PayerUuid] = None,
        organization_billing_provider_id: typing.Optional[OrganizationProviderId] = None,
        states: typing.Optional[typing.Union[State, typing.Sequence[State]]] = None,
        zip_codes: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        license_types: typing.Optional[typing.Union[LicenseType, typing.Sequence[LicenseType]]] = None,
        facility_type_codes: typing.Optional[typing.Union[FacilityTypeCode, typing.Sequence[FacilityTypeCode]]] = None,
        network_types: typing.Optional[typing.Union[NetworkType, typing.Sequence[NetworkType]]] = None,
        payer_plan_group_ids: typing.Optional[typing.Union[PayerPlanGroupId, typing.Sequence[PayerPlanGroupId]]] = None,
        cpt_code: typing.Optional[str] = None,
        modifiers: typing.Optional[typing.Union[ProcedureModifier, typing.Sequence[ProcedureModifier]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DimensionsPage]:
        """
        Gets unique values for a dimension based on other selection criteria. The response is a list of dimensions with your criteria and the unique values populated. This API is useful for driving pivots on dimension values.

        Parameters
        ----------
        pivot_dimension : DimensionName
            The name of the dimension to fetch unique values for.

        page_token : typing.Optional[PageToken]

        limit : typing.Optional[int]
            Max number of values returned. Defaults to 1000. Max is 1000.

        payer_uuid : typing.Optional[PayerUuid]

        organization_billing_provider_id : typing.Optional[OrganizationProviderId]

        states : typing.Optional[typing.Union[State, typing.Sequence[State]]]

        zip_codes : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        license_types : typing.Optional[typing.Union[LicenseType, typing.Sequence[LicenseType]]]

        facility_type_codes : typing.Optional[typing.Union[FacilityTypeCode, typing.Sequence[FacilityTypeCode]]]

        network_types : typing.Optional[typing.Union[NetworkType, typing.Sequence[NetworkType]]]

        payer_plan_group_ids : typing.Optional[typing.Union[PayerPlanGroupId, typing.Sequence[PayerPlanGroupId]]]

        cpt_code : typing.Optional[str]

        modifiers : typing.Optional[typing.Union[ProcedureModifier, typing.Sequence[ProcedureModifier]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DimensionsPage]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/fee-schedules/v3/unique-dimension-values",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "page_token": page_token,
                "limit": limit,
                "pivot_dimension": pivot_dimension,
                "payer_uuid": payer_uuid,
                "organization_billing_provider_id": organization_billing_provider_id,
                "states": states,
                "zip_codes": zip_codes,
                "license_types": license_types,
                "facility_type_codes": facility_type_codes,
                "network_types": network_types,
                "payer_plan_group_ids": payer_plan_group_ids,
                "cpt_code": cpt_code,
                "modifiers": modifiers,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                DimensionsPage,
                parse_obj_as(
                    type_=DimensionsPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_rate_history(
        self, rate_id: RateId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[Rate]]:
        """
        Gets every version of a rate.

        Parameters
        ----------
        rate_id : RateId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[Rate]]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/fee-schedules/v3/{jsonable_encoder(rate_id)}/history",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                typing.List[Rate],
                parse_obj_as(
                    type_=typing.List[Rate],  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def upload_fee_schedule(
        self,
        *,
        dry_run: bool,
        rates: typing.Sequence[RateUpload],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[Rate]]:
        """
        Uploads a new fee schedule.\n Each rate may either be totally new as qualified by it's dimensions or a new version for an existing rate.\n If adding a new version to an existing rate, the rate must be posted with the next version number (previous version + 1) or a EntityConflictError will be returned.\n Use the dry run flag to discover already existing rates and to run validations.  If validations for any rate fail, no rates will be saved to the system.

        Parameters
        ----------
        dry_run : bool

        rates : typing.Sequence[RateUpload]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[Rate]]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/fee-schedules/v3",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json={
                "dry_run": dry_run,
                "rates": rates,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                typing.List[Rate],
                parse_obj_as(
                    type_=typing.List[Rate],  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "FeeScheduleValidationHttpError":
                raise FeeScheduleValidationHttpError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RateUploadWithPossibleErrors],
                        parse_obj_as(
                            type_=typing.List[RateUploadWithPossibleErrors],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_rate(
        self, rate_id: RateId, version: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Soft deletes a rate from the system.  Only the most recent version of a rate can be deleted.

        Parameters
        ----------
        rate_id : RateId

        version : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/fee-schedules/v3/{jsonable_encoder(rate_id)}/{jsonable_encoder(version)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="DELETE",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return AsyncHttpResponse(response=_response, data=None)
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityConflictError":
                raise EntityConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityConflictErrorMessage,
                        parse_obj_as(
                            type_=EntityConflictErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_payer_thresholds_default(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PayerThreshold]:
        """
        Gets the default payer threshold

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PayerThreshold]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/fee-schedules/v3/payer-threshold/default",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                PayerThreshold,
                parse_obj_as(
                    type_=PayerThreshold,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_payer_thresholds(
        self,
        *,
        payer_uuids: typing.Union[PayerUuid, typing.Sequence[PayerUuid]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PayerThresholdsPage]:
        """
        Gets a list of payers and thresholds by their uuids

        Parameters
        ----------
        payer_uuids : typing.Union[PayerUuid, typing.Sequence[PayerUuid]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PayerThresholdsPage]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/fee-schedules/v3/payer-threshold",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "payer_uuids": payer_uuids,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                PayerThresholdsPage,
                parse_obj_as(
                    type_=PayerThresholdsPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def set_payer_threshold(
        self, payer_uuid: PayerUuid, *, request: PayerThreshold, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PayerThreshold]:
        """
        Sets the threshold information for a payer

        Parameters
        ----------
        payer_uuid : PayerUuid

        request : PayerThreshold

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PayerThreshold]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/fee-schedules/v3/payer-threshold/{jsonable_encoder(payer_uuid)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PUT",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                PayerThreshold,
                parse_obj_as(
                    type_=PayerThreshold,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
