# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class PayerThreshold(UniversalBaseModel):
    """
    Rate thresholds that determine fee schedule rate matching behavior.  When a service line is adjudicated by a payer Candid determines if the payer's allowed amount "matches" the rate value.  If the allowed amount doesn't equal the rate value, Candid moves the claim to a PAID_INCORRECTLY state.  These optional thresholds allow a user to set wiggle room to avoid claims moving to PAID_INCORRECTLY and instead have them move directly to FINALIZED_PAID when the payer's allowed amount is greater than [rate_cents - lower_threshold_cents] and less than [rate_cents + upper_threshold_cents].\n Additionally, a client can set disable_paid_incorrectly to avoid the PAID_INCORRECTLY claim status entirely.
    """

    upper_threshold_cents: typing.Optional[int] = None
    lower_threshold_cents: typing.Optional[int] = None
    disable_paid_incorrectly: bool

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
