# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....commons.types.rate_id import RateId
from .....commons.types.user_id import UserId
from .dimensions import Dimensions
from .rate_entry import RateEntry


class Rate(UniversalBaseModel):
    """
    A comprehensive rate including the current rate value and all values for historic time ranges. The time ranges specified by each RateEntry are disjoint.  A rate must always have at least one entry.
    """

    rate_id: RateId
    dimensions: Dimensions = pydantic.Field()
    """
    The dimension values that distinguish this rate from others.
    """

    version: int = pydantic.Field()
    """
    The version of this rate in the system.
    """

    updated_at: dt.date
    updated_by: UserId
    entries: typing.List[RateEntry]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
