# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class RateEntry(UniversalBaseModel):
    """
    A rate value in cents for a specific time range.  Rate entries can be deactivated, which is set by using the deelte_rate endpoint.  Deactivated rate entries are not considered when matching against service lines.

    Examples
    --------
    import datetime

    from candid.resources.fee_schedules.resources.v_3 import RateEntry

    RateEntry(
        start_date=datetime.date.fromisoformat(
            "2024-04-11",
        ),
        rate_cents=33000,
        is_deactivated=False,
    )
    """

    start_date: dt.date
    end_date: typing.Optional[dt.date] = None
    rate_cents: int
    is_deactivated: bool

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
