# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...commons.types.appointment_id import AppointmentId
from ...commons.types.claim_id import ClaimId
from ...commons.types.encounter_id import EncounterId
from ...commons.types.patient_external_id import PatientExternalId
from ...commons.types.provider_id import ProviderId
from ...commons.types.service_line_id import ServiceLineId


class AllocationTarget_ServiceLine(UniversalBaseModel):
    """
    Allocation targets describe whether the portion of a payment is being applied toward a specific service line,
    claim, billing provider, or is unallocated.
    """

    type: typing.Literal["service_line"] = "service_line"
    service_line_id: ServiceLineId
    claim_id: ClaimId
    encounter_id: EncounterId

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AllocationTarget_Claim(UniversalBaseModel):
    """
    Allocation targets describe whether the portion of a payment is being applied toward a specific service line,
    claim, billing provider, or is unallocated.
    """

    type: typing.Literal["claim"] = "claim"
    claim_id: ClaimId
    encounter_id: EncounterId

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AllocationTarget_BillingProviderId(UniversalBaseModel):
    """
    Allocation targets describe whether the portion of a payment is being applied toward a specific service line,
    claim, billing provider, or is unallocated.
    """

    type: typing.Literal["billing_provider_id"] = "billing_provider_id"
    billing_provider_id: ProviderId

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AllocationTarget_Appointment(UniversalBaseModel):
    """
    Allocation targets describe whether the portion of a payment is being applied toward a specific service line,
    claim, billing provider, or is unallocated.
    """

    type: typing.Literal["appointment"] = "appointment"
    appointment_id: AppointmentId
    patient_external_id: PatientExternalId

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AllocationTarget_Unattributed(UniversalBaseModel):
    """
    Allocation targets describe whether the portion of a payment is being applied toward a specific service line,
    claim, billing provider, or is unallocated.
    """

    type: typing.Literal["unattributed"] = "unattributed"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


AllocationTarget = typing.Union[
    AllocationTarget_ServiceLine,
    AllocationTarget_Claim,
    AllocationTarget_BillingProviderId,
    AllocationTarget_Appointment,
    AllocationTarget_Unattributed,
]
