# This file was auto-generated by Fern from our API Definition.

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawGuarantorClient, RawGuarantorClient
from .resources.v_1.client import AsyncV1Client, V1Client


class GuarantorClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawGuarantorClient(client_wrapper=client_wrapper)
        self.v_1 = V1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawGuarantorClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawGuarantorClient
        """
        return self._raw_client


class AsyncGuarantorClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawGuarantorClient(client_wrapper=client_wrapper)
        self.v_1 = AsyncV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawGuarantorClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawGuarantorClient
        """
        return self._raw_client
