# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ....commons.types.encounter_id import EncounterId
from .raw_client import AsyncRawV1Client, RawV1Client
from .types.guarantor import Guarantor
from .types.guarantor_create import GuarantorCreate
from .types.guarantor_id import GuarantorId
from .types.guarantor_update import GuarantorUpdate

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV1Client
        """
        return self._raw_client

    def create(
        self,
        encounter_id: EncounterId,
        *,
        request: GuarantorCreate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Guarantor:
        """
        Creates a new guarantor and returns the newly created Guarantor object.

        Parameters
        ----------
        encounter_id : EncounterId

        request : GuarantorCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Guarantor

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.commons import State, StreetAddressShortZip
        from candid.resources.guarantor.resources.v_1 import GuarantorCreate

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.guarantor.v_1.create(
            encounter_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            request=GuarantorCreate(
                first_name="first_name",
                last_name="last_name",
                external_id="external_id",
                address=StreetAddressShortZip(
                    address_1="address1",
                    city="city",
                    state=State.AA,
                    zip_code="zip_code",
                ),
            ),
        )
        """
        _response = self._raw_client.create(encounter_id, request=request, request_options=request_options)
        return _response.data

    def get(self, guarantor_id: GuarantorId, *, request_options: typing.Optional[RequestOptions] = None) -> Guarantor:
        """
        Retrieves a guarantor by its `guarantor_id`.

        Parameters
        ----------
        guarantor_id : GuarantorId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Guarantor

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.guarantor.v_1.get(
            guarantor_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.get(guarantor_id, request_options=request_options)
        return _response.data

    def update(
        self,
        guarantor_id: GuarantorId,
        *,
        request: GuarantorUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Guarantor:
        """
        Updates a guarantor by its `guarantor_id`.

        Parameters
        ----------
        guarantor_id : GuarantorId

        request : GuarantorUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Guarantor

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.guarantor.resources.v_1 import GuarantorUpdate

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.guarantor.v_1.update(
            guarantor_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            request=GuarantorUpdate(),
        )
        """
        _response = self._raw_client.update(guarantor_id, request=request, request_options=request_options)
        return _response.data


class AsyncV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV1Client
        """
        return self._raw_client

    async def create(
        self,
        encounter_id: EncounterId,
        *,
        request: GuarantorCreate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Guarantor:
        """
        Creates a new guarantor and returns the newly created Guarantor object.

        Parameters
        ----------
        encounter_id : EncounterId

        request : GuarantorCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Guarantor

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.commons import State, StreetAddressShortZip
        from candid.resources.guarantor.resources.v_1 import GuarantorCreate

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.guarantor.v_1.create(
                encounter_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                request=GuarantorCreate(
                    first_name="first_name",
                    last_name="last_name",
                    external_id="external_id",
                    address=StreetAddressShortZip(
                        address_1="address1",
                        city="city",
                        state=State.AA,
                        zip_code="zip_code",
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(encounter_id, request=request, request_options=request_options)
        return _response.data

    async def get(
        self, guarantor_id: GuarantorId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Guarantor:
        """
        Retrieves a guarantor by its `guarantor_id`.

        Parameters
        ----------
        guarantor_id : GuarantorId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Guarantor

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.guarantor.v_1.get(
                guarantor_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(guarantor_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        guarantor_id: GuarantorId,
        *,
        request: GuarantorUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Guarantor:
        """
        Updates a guarantor by its `guarantor_id`.

        Parameters
        ----------
        guarantor_id : GuarantorId

        request : GuarantorUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Guarantor

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.guarantor.resources.v_1 import GuarantorUpdate

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.guarantor.v_1.update(
                guarantor_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                request=GuarantorUpdate(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(guarantor_id, request=request, request_options=request_options)
        return _response.data
