# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.jsonable_encoder import jsonable_encoder
from .....core.pydantic_utilities import parse_obj_as
from .....core.request_options import RequestOptions
from ....commons.errors.http_request_validations_error import HttpRequestValidationsError
from ....commons.types.encounter_id import EncounterId
from ....commons.types.request_validation_error import RequestValidationError
from .errors.encounter_has_existing_guarantor_error import EncounterHasExistingGuarantorError
from .types.encounter_has_existing_guarantor_error_type import EncounterHasExistingGuarantorErrorType
from .types.guarantor import Guarantor
from .types.guarantor_create import GuarantorCreate
from .types.guarantor_id import GuarantorId
from .types.guarantor_update import GuarantorUpdate

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawV1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self,
        encounter_id: EncounterId,
        *,
        request: GuarantorCreate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Guarantor]:
        """
        Creates a new guarantor and returns the newly created Guarantor object.

        Parameters
        ----------
        encounter_id : EncounterId

        request : GuarantorCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Guarantor]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/guarantors/v1/{jsonable_encoder(encounter_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                Guarantor,
                parse_obj_as(
                    type_=Guarantor,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EncounterHasExistingGuarantorError":
                raise EncounterHasExistingGuarantorError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EncounterHasExistingGuarantorErrorType,
                        parse_obj_as(
                            type_=EncounterHasExistingGuarantorErrorType,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, guarantor_id: GuarantorId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Guarantor]:
        """
        Retrieves a guarantor by its `guarantor_id`.

        Parameters
        ----------
        guarantor_id : GuarantorId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Guarantor]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/guarantors/v1/{jsonable_encoder(guarantor_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                Guarantor,
                parse_obj_as(
                    type_=Guarantor,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        guarantor_id: GuarantorId,
        *,
        request: GuarantorUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Guarantor]:
        """
        Updates a guarantor by its `guarantor_id`.

        Parameters
        ----------
        guarantor_id : GuarantorId

        request : GuarantorUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Guarantor]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/guarantors/v1/{jsonable_encoder(guarantor_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                Guarantor,
                parse_obj_as(
                    type_=Guarantor,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self,
        encounter_id: EncounterId,
        *,
        request: GuarantorCreate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Guarantor]:
        """
        Creates a new guarantor and returns the newly created Guarantor object.

        Parameters
        ----------
        encounter_id : EncounterId

        request : GuarantorCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Guarantor]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/guarantors/v1/{jsonable_encoder(encounter_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                Guarantor,
                parse_obj_as(
                    type_=Guarantor,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EncounterHasExistingGuarantorError":
                raise EncounterHasExistingGuarantorError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EncounterHasExistingGuarantorErrorType,
                        parse_obj_as(
                            type_=EncounterHasExistingGuarantorErrorType,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, guarantor_id: GuarantorId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Guarantor]:
        """
        Retrieves a guarantor by its `guarantor_id`.

        Parameters
        ----------
        guarantor_id : GuarantorId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Guarantor]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/guarantors/v1/{jsonable_encoder(guarantor_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                Guarantor,
                parse_obj_as(
                    type_=Guarantor,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        guarantor_id: GuarantorId,
        *,
        request: GuarantorUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Guarantor]:
        """
        Updates a guarantor by its `guarantor_id`.

        Parameters
        ----------
        guarantor_id : GuarantorId

        request : GuarantorUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Guarantor]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/guarantors/v1/{jsonable_encoder(guarantor_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                Guarantor,
                parse_obj_as(
                    type_=Guarantor,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
