# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2
from .....commons.types.email import Email
from .....commons.types.phone_number import PhoneNumber
from .guarantor_base import GuarantorBase
from .guarantor_id import GuarantorId


class Guarantor(GuarantorBase):
    """
    Examples
    --------
    import datetime
    import uuid

    from candid.resources.commons import (
        PhoneNumber,
        PhoneNumberType,
        State,
        StreetAddressShortZip,
    )
    from candid.resources.guarantor.resources.v_1 import Guarantor

    Guarantor(
        guarantor_id=uuid.UUID(
            "8bbdbe63-58d3-4d40-98c9-40403c050977",
        ),
        phone_numbers=[
            PhoneNumber(
                number="1234567890",
                type=PhoneNumberType.HOME,
            )
        ],
        phone_consent=True,
        email="johndoe@joincandidhealth.com",
        email_consent=True,
        first_name="John",
        last_name="Doe",
        external_id="49460F77-6456-41F1-AC6D-0AED08614D39",
        date_of_birth=datetime.date.fromisoformat(
            "2000-01-01",
        ),
        address=StreetAddressShortZip(
            address_1="123 Main St",
            address_2="Apt 1",
            city="New York",
            state=State.NY,
            zip_code="10001",
            zip_plus_four_code="1234",
        ),
    )
    """

    guarantor_id: GuarantorId
    phone_numbers: typing.List[PhoneNumber]
    phone_consent: bool
    email: typing.Optional[Email] = None
    email_consent: bool

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
