# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....commons.types.email import Email
from .....commons.types.phone_number import PhoneNumber
from .....commons.types.street_address_short_zip import StreetAddressShortZip


class GuarantorUpdate(UniversalBaseModel):
    first_name: typing.Optional[str] = None
    last_name: typing.Optional[str] = None
    external_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    A unique identifier for the guarantor assigned by an external system.
    """

    date_of_birth: typing.Optional[dt.date] = pydantic.Field(default=None)
    """
    Date formatted as YYYY-MM-DD; eg: 2019-08-25.
    """

    address: typing.Optional[StreetAddressShortZip] = None
    phone_numbers: typing.Optional[typing.List[PhoneNumber]] = None
    phone_consent: typing.Optional[bool] = None
    email: typing.Optional[Email] = None
    email_consent: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
