# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from .identifier_base import IdentifierBase
from .identifier_id import IdentifierId


class Identifier(IdentifierBase):
    """
    Examples
    --------
    import uuid

    from candid.resources.commons import State
    from candid.resources.identifiers import (
        Identifier,
        IdentifierCode,
        IdentifierValue_MedicareProviderIdentifier,
    )

    Identifier(
        identifier_id=uuid.UUID(
            "123e4567-e89b-12d3-a456-426614174000",
        ),
        identifier_code=IdentifierCode.MCR,
        identifier_value=IdentifierValue_MedicareProviderIdentifier(
            state=State.CA,
            provider_number="1234567890",
        ),
    )
    """

    identifier_id: IdentifierId

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
