# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...commons.types.date_range_optional_end import DateRangeOptionalEnd
from ...commons.types.removable_date_range_optional_end import RemovableDateRangeOptionalEnd
from .identifier_code import IdentifierCode
from .identifier_id import IdentifierId
from .identifier_value import IdentifierValue


class UpdatableIdentifier_Add(UniversalBaseModel):
    type: typing.Literal["add"] = "add"
    period: typing.Optional[DateRangeOptionalEnd] = None
    identifier_code: IdentifierCode
    identifier_value: IdentifierValue

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class UpdatableIdentifier_Update(UniversalBaseModel):
    type: typing.Literal["update"] = "update"
    identifier_id: IdentifierId
    identifier_code: typing.Optional[IdentifierCode] = None
    identifier_value: typing.Optional[IdentifierValue] = None
    period: typing.Optional[RemovableDateRangeOptionalEnd] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class UpdatableIdentifier_Remove(UniversalBaseModel):
    value: IdentifierId
    type: typing.Literal["remove"] = "remove"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True


UpdatableIdentifier = typing.Union[UpdatableIdentifier_Add, UpdatableIdentifier_Update, UpdatableIdentifier_Remove]
