# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ....commons.types.encounter_external_id import EncounterExternalId
from ....commons.types.invoice_id import InvoiceId
from ....commons.types.page_token import PageToken
from ....commons.types.patient_external_id import PatientExternalId
from ....commons.types.sort_direction import SortDirection
from ....invoices.resources.v_2.types.invoice_sort_field import InvoiceSortField
from ....invoices.resources.v_2.types.invoice_status import InvoiceStatus
from .raw_client import AsyncRawV1Client, RawV1Client
from .types.create_import_invoice_request import CreateImportInvoiceRequest
from .types.import_invoice import ImportInvoice
from .types.import_invoice_update_request import ImportInvoiceUpdateRequest
from .types.import_invoices_page import ImportInvoicesPage

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV1Client
        """
        return self._raw_client

    def import_invoice(
        self, *, request: CreateImportInvoiceRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> ImportInvoice:
        """
        Import an existing invoice from a third party service to reflect state in Candid.

        Parameters
        ----------
        request : CreateImportInvoiceRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ImportInvoice

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.import_invoice.resources.v_1 import (
            CreateImportInvoiceRequest,
        )
        from candid.resources.invoices.resources.v_2 import (
            InvoiceItemAttributionCreate_ServiceLineId,
            InvoiceItemCreate,
            InvoiceStatus,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.import_invoice.v_1.import_invoice(
            request=CreateImportInvoiceRequest(
                external_payment_account_config_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                patient_external_id="patient_external_id",
                external_customer_identifier="external_customer_identifier",
                items=[
                    InvoiceItemCreate(
                        attribution=InvoiceItemAttributionCreate_ServiceLineId(
                            value=uuid.UUID(
                                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                            )
                        ),
                        amount_cents=1,
                    ),
                    InvoiceItemCreate(
                        attribution=InvoiceItemAttributionCreate_ServiceLineId(
                            value=uuid.UUID(
                                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                            )
                        ),
                        amount_cents=1,
                    ),
                ],
                status=InvoiceStatus.DRAFT,
                external_identifier="external_identifier",
            ),
        )
        """
        _response = self._raw_client.import_invoice(request=request, request_options=request_options)
        return _response.data

    def get_multi(
        self,
        *,
        patient_external_id: typing.Optional[PatientExternalId] = None,
        encounter_external_id: typing.Optional[EncounterExternalId] = None,
        note: typing.Optional[str] = None,
        due_date_before: typing.Optional[dt.date] = None,
        due_date_after: typing.Optional[dt.date] = None,
        status: typing.Optional[typing.Union[InvoiceStatus, typing.Sequence[InvoiceStatus]]] = None,
        limit: typing.Optional[int] = None,
        sort: typing.Optional[InvoiceSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ImportInvoicesPage:
        """
        Returns all Invoices for the authenticated user's organziation with all filters applied.

        Parameters
        ----------
        patient_external_id : typing.Optional[PatientExternalId]

        encounter_external_id : typing.Optional[EncounterExternalId]

        note : typing.Optional[str]
            partial match supported

        due_date_before : typing.Optional[dt.date]
            all invoices whose due date is before this due date, not inclusive

        due_date_after : typing.Optional[dt.date]
            all invoices whose due date is after this due date, not inclusive

        status : typing.Optional[typing.Union[InvoiceStatus, typing.Sequence[InvoiceStatus]]]
            all invoices that match any of the provided statuses

        limit : typing.Optional[int]
            Defaults to 100

        sort : typing.Optional[InvoiceSortField]
            Defaults to created_at

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to descending order

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ImportInvoicesPage

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.import_invoice.v_1.get_multi()
        """
        _response = self._raw_client.get_multi(
            patient_external_id=patient_external_id,
            encounter_external_id=encounter_external_id,
            note=note,
            due_date_before=due_date_before,
            due_date_after=due_date_after,
            status=status,
            limit=limit,
            sort=sort,
            sort_direction=sort_direction,
            page_token=page_token,
            request_options=request_options,
        )
        return _response.data

    def get(self, invoice_id: InvoiceId, *, request_options: typing.Optional[RequestOptions] = None) -> ImportInvoice:
        """
        Retrieve and view an import invoice

        Parameters
        ----------
        invoice_id : InvoiceId
            InvoiceId to be returned

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ImportInvoice

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.import_invoice.v_1.get(
            invoice_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.get(invoice_id, request_options=request_options)
        return _response.data

    def update(
        self,
        invoice_id: InvoiceId,
        *,
        request: ImportInvoiceUpdateRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ImportInvoice:
        """
        Update the information on the imported invoice

        Parameters
        ----------
        invoice_id : InvoiceId

        request : ImportInvoiceUpdateRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ImportInvoice

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.import_invoice.resources.v_1 import (
            ImportInvoiceUpdateRequest,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.import_invoice.v_1.update(
            invoice_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            request=ImportInvoiceUpdateRequest(),
        )
        """
        _response = self._raw_client.update(invoice_id, request=request, request_options=request_options)
        return _response.data


class AsyncV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV1Client
        """
        return self._raw_client

    async def import_invoice(
        self, *, request: CreateImportInvoiceRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> ImportInvoice:
        """
        Import an existing invoice from a third party service to reflect state in Candid.

        Parameters
        ----------
        request : CreateImportInvoiceRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ImportInvoice

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.import_invoice.resources.v_1 import (
            CreateImportInvoiceRequest,
        )
        from candid.resources.invoices.resources.v_2 import (
            InvoiceItemAttributionCreate_ServiceLineId,
            InvoiceItemCreate,
            InvoiceStatus,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.import_invoice.v_1.import_invoice(
                request=CreateImportInvoiceRequest(
                    external_payment_account_config_id=uuid.UUID(
                        "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                    ),
                    patient_external_id="patient_external_id",
                    external_customer_identifier="external_customer_identifier",
                    items=[
                        InvoiceItemCreate(
                            attribution=InvoiceItemAttributionCreate_ServiceLineId(
                                value=uuid.UUID(
                                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                                )
                            ),
                            amount_cents=1,
                        ),
                        InvoiceItemCreate(
                            attribution=InvoiceItemAttributionCreate_ServiceLineId(
                                value=uuid.UUID(
                                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                                )
                            ),
                            amount_cents=1,
                        ),
                    ],
                    status=InvoiceStatus.DRAFT,
                    external_identifier="external_identifier",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.import_invoice(request=request, request_options=request_options)
        return _response.data

    async def get_multi(
        self,
        *,
        patient_external_id: typing.Optional[PatientExternalId] = None,
        encounter_external_id: typing.Optional[EncounterExternalId] = None,
        note: typing.Optional[str] = None,
        due_date_before: typing.Optional[dt.date] = None,
        due_date_after: typing.Optional[dt.date] = None,
        status: typing.Optional[typing.Union[InvoiceStatus, typing.Sequence[InvoiceStatus]]] = None,
        limit: typing.Optional[int] = None,
        sort: typing.Optional[InvoiceSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ImportInvoicesPage:
        """
        Returns all Invoices for the authenticated user's organziation with all filters applied.

        Parameters
        ----------
        patient_external_id : typing.Optional[PatientExternalId]

        encounter_external_id : typing.Optional[EncounterExternalId]

        note : typing.Optional[str]
            partial match supported

        due_date_before : typing.Optional[dt.date]
            all invoices whose due date is before this due date, not inclusive

        due_date_after : typing.Optional[dt.date]
            all invoices whose due date is after this due date, not inclusive

        status : typing.Optional[typing.Union[InvoiceStatus, typing.Sequence[InvoiceStatus]]]
            all invoices that match any of the provided statuses

        limit : typing.Optional[int]
            Defaults to 100

        sort : typing.Optional[InvoiceSortField]
            Defaults to created_at

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to descending order

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ImportInvoicesPage

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.import_invoice.v_1.get_multi()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_multi(
            patient_external_id=patient_external_id,
            encounter_external_id=encounter_external_id,
            note=note,
            due_date_before=due_date_before,
            due_date_after=due_date_after,
            status=status,
            limit=limit,
            sort=sort,
            sort_direction=sort_direction,
            page_token=page_token,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, invoice_id: InvoiceId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ImportInvoice:
        """
        Retrieve and view an import invoice

        Parameters
        ----------
        invoice_id : InvoiceId
            InvoiceId to be returned

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ImportInvoice

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.import_invoice.v_1.get(
                invoice_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(invoice_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        invoice_id: InvoiceId,
        *,
        request: ImportInvoiceUpdateRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ImportInvoice:
        """
        Update the information on the imported invoice

        Parameters
        ----------
        invoice_id : InvoiceId

        request : ImportInvoiceUpdateRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ImportInvoice

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.import_invoice.resources.v_1 import (
            ImportInvoiceUpdateRequest,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.import_invoice.v_1.update(
                invoice_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                request=ImportInvoiceUpdateRequest(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(invoice_id, request=request, request_options=request_options)
        return _response.data
