# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....commons.types.patient_external_id import PatientExternalId
from .....invoices.resources.v_2.types.invoice_item_create import InvoiceItemCreate
from .....invoices.resources.v_2.types.invoice_status import InvoiceStatus
from .....payment_account_configs.types.payment_account_config_id import PaymentAccountConfigId


class CreateImportInvoiceRequest(UniversalBaseModel):
    external_payment_account_config_id: PaymentAccountConfigId
    patient_external_id: PatientExternalId
    external_customer_identifier: str = pydantic.Field()
    """
    Id of the customer in the source system
    """

    note: typing.Optional[str] = None
    due_date: typing.Optional[dt.date] = pydantic.Field(default=None)
    """
    If given as None, days_until_due in the payment config will be used to create a default date
    """

    items: typing.List[InvoiceItemCreate]
    status: InvoiceStatus
    external_identifier: str = pydantic.Field()
    """
    Id of the invoice being imported in the source system. Warning - This field CANNOT be updated.
    """

    customer_invoice_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Link to the patient view of the invoice in the third-party service
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
