# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....commons.types.invoice_id import InvoiceId
from .....commons.types.patient_external_id import PatientExternalId
from .....invoices.resources.v_2.types.invoice_item_info import InvoiceItemInfo
from .....invoices.resources.v_2.types.invoice_status import InvoiceStatus


class ImportInvoice(UniversalBaseModel):
    id: InvoiceId
    created_at: dt.datetime
    updated_at: dt.datetime
    items: InvoiceItemInfo = pydantic.Field()
    """
    The InvoiceItem rollup which contains all claim and service line invoice items
    """

    patient_external_id: PatientExternalId
    external_customer_identifier: str = pydantic.Field()
    """
    Id of the customer in the source system
    """

    status: InvoiceStatus
    external_identifier: str = pydantic.Field()
    """
    Id of the invoice being imported in the source system
    """

    note: typing.Optional[str] = None
    customer_invoice_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Link to the patient view of the invoice in the third-party service
    """

    due_date: dt.date
    amount_cents: int = pydantic.Field()
    """
    Total monetary amount (in cents) of all Invoice Items
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
