# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ...commons.types.email import Email
from ...commons.types.phone_number import PhoneNumber
from ...non_insurance_payers.resources.v_1.types.non_insurance_payer import NonInsurancePayer
from .individual_id import IndividualId
from .patient_base import PatientBase
from .patient_non_insurance_payer_info import PatientNonInsurancePayerInfo


class Patient(PatientBase):
    """
    Examples
    --------
    import datetime
    import uuid

    from candid.resources.commons import (
        PhoneNumber,
        PhoneNumberType,
        State,
        StreetAddressShortZip,
    )
    from candid.resources.individual import (
        Gender,
        Patient,
        PatientNonInsurancePayerInfo,
    )
    from candid.resources.non_insurance_payers.resources.v_1 import (
        NonInsurancePayer,
    )

    Patient(
        individual_id=uuid.UUID(
            "93ddbebf-4956-4482-9a6c-21499b7e4e5d",
        ),
        phone_numbers=[
            PhoneNumber(
                number="1234567890",
                type=PhoneNumberType.HOME,
            )
        ],
        non_insurance_payers=[
            NonInsurancePayer(
                non_insurance_payer_id=uuid.UUID(
                    "eb7623ab-d5bc-4b25-b257-2b8fcec578de",
                ),
                name="Sunrise Foundation",
                category="Foundation",
                description="Sunrise Foundation is a non-profit organization that provides financial assistance to patients in need.",
                enabled=True,
                address=StreetAddressShortZip(
                    address_1="123 Main St",
                    city="San Francisco",
                    state=State.CA,
                    zip_code="94105",
                ),
                clinical_trials=[],
            )
        ],
        non_insurance_payers_info=[
            PatientNonInsurancePayerInfo(
                non_insurance_payer=NonInsurancePayer(
                    non_insurance_payer_id=uuid.UUID(
                        "eb7623ab-d5bc-4b25-b257-2b8fcec578de",
                    ),
                    name="Sunrise Foundation",
                    category="Foundation",
                    description="Sunrise Foundation is a non-profit organization that provides financial assistance to patients in need.",
                    enabled=True,
                    address=StreetAddressShortZip(
                        address_1="123 Main St",
                        city="San Francisco",
                        state=State.CA,
                        zip_code="94105",
                    ),
                    clinical_trials=[],
                ),
                member_id="123456789",
                clinical_trial_info=[],
            )
        ],
        phone_consent=True,
        email="johndoe@joincandidhealth.com",
        email_consent=True,
        external_id="49460F77-6456-41F1-AC6D-0AED08614D39",
        date_of_birth=datetime.date.fromisoformat(
            "2000-01-01",
        ),
        address=StreetAddressShortZip(
            address_1="123 Main St",
            address_2="Apt 1",
            city="New York",
            state=State.NY,
            zip_code="10001",
            zip_plus_four_code="1234",
        ),
        first_name="John",
        last_name="Doe",
        gender=Gender.MALE,
    )
    """

    individual_id: IndividualId
    phone_numbers: typing.List[PhoneNumber]
    phone_consent: bool
    email: typing.Optional[Email] = None
    email_consent: bool
    non_insurance_payers: typing.List[NonInsurancePayer]
    non_insurance_payers_info: typing.List[PatientNonInsurancePayerInfo]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
